/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.rdbms;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.util.bloom.Key;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.extension.eventtable.rdbms.DBHandler;
import org.wso2.siddhi.extension.eventtable.rdbms.ExecutionInfo;
import org.wso2.siddhi.query.api.definition.Attribute;

public class RDBMSOperator
implements Operator {
    private Operator inMemoryEventTableOperator;
    private List<ExpressionExecutor> expressionExecutorList;
    private DBHandler dbHandler;
    private boolean isBloomEnabled;
    private final int[] attributeIndexArray;
    private ExecutionInfo executionInfo;
    private int matchingEventOutputSize;

    public RDBMSOperator(ExecutionInfo executionInfo, List<ExpressionExecutor> expressionExecutorList, DBHandler dbHandler, Operator inMemoryEventTableOperator, int matchingEventOutputSize) {
        this.expressionExecutorList = expressionExecutorList;
        this.dbHandler = dbHandler;
        this.inMemoryEventTableOperator = inMemoryEventTableOperator;
        this.executionInfo = executionInfo;
        this.matchingEventOutputSize = matchingEventOutputSize;
        if (dbHandler.isBloomFilterEnabled() && executionInfo.isBloomFilterCompatible()) {
            this.isBloomEnabled = true;
        }
        List<Attribute> conditionList = executionInfo.getConditionQueryColumnOrder();
        this.attributeIndexArray = new int[conditionList.size()];
        int i = 0;
        for (Attribute attribute : conditionList) {
            this.attributeIndexArray[i++] = RDBMSOperator.getAttributeIndex(dbHandler, attribute.getName());
        }
    }

    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object candidateEvents) {
        deletingEventChunk.reset();
        ArrayList<Object[]> deletionEventList = new ArrayList<Object[]>();
        while (deletingEventChunk.hasNext()) {
            Object[] obj;
            ComplexEvent deletingEvent = deletingEventChunk.next();
            if (this.expressionExecutorList != null) {
                obj = new Object[this.expressionExecutorList.size()];
                int count = 0;
                for (ExpressionExecutor expressionExecutor : this.expressionExecutorList) {
                    Object value;
                    obj[count] = value = expressionExecutor.execute(deletingEvent);
                    ++count;
                }
            } else {
                obj = new Object[]{};
            }
            deletionEventList.add(obj);
        }
        if (deletionEventList.size() > 0) {
            this.dbHandler.deleteEvent(deletionEventList, this.executionInfo);
        }
    }

    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers) {
        updatingEventChunk.reset();
        ArrayList<Object[]> updateEventList = new ArrayList<Object[]>();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            Object[] incomingEvent = updatingEvent.getStreamEvent(0).getOutputData();
            Object[] obj = new Object[this.matchingEventOutputSize + this.expressionExecutorList.size()];
            System.arraycopy(incomingEvent, 0, obj, 0, this.matchingEventOutputSize);
            int count = this.matchingEventOutputSize;
            for (ExpressionExecutor expressionExecutor : this.expressionExecutorList) {
                Object value;
                obj[count] = value = expressionExecutor.execute((ComplexEvent)updatingEvent);
                ++count;
            }
            updateEventList.add(obj);
        }
        if (updateEventList.size() > 0) {
            this.dbHandler.updateEvent(updateEventList, this.executionInfo);
        }
    }

    public ComplexEventChunk<StreamEvent> overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        overwritingOrAddingEventChunk.reset();
        ArrayList<Object[]> updateEventList = new ArrayList<Object[]>();
        while (overwritingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)overwritingOrAddingEventChunk.next();
            Object[] incomingEvent = overwritingOrAddingEvent.getStreamEvent(0).getOutputData();
            Object[] obj = new Object[this.matchingEventOutputSize + this.expressionExecutorList.size()];
            System.arraycopy(incomingEvent, 0, obj, 0, this.matchingEventOutputSize);
            int count = this.matchingEventOutputSize;
            for (ExpressionExecutor expressionExecutor : this.expressionExecutorList) {
                Object value;
                obj[count] = value = expressionExecutor.execute((ComplexEvent)overwritingOrAddingEvent);
                ++count;
            }
            updateEventList.add(obj);
        }
        this.dbHandler.overwriteOrAddEvent(updateEventList, this.executionInfo);
        return null;
    }

    public Finder cloneFinder(String key) {
        return new RDBMSOperator(this.executionInfo, this.expressionExecutorList, this.dbHandler, this.inMemoryEventTableOperator, this.matchingEventOutputSize);
    }

    public StreamEvent find(StateEvent matchingEvent, Object candidateEvents, StreamEventCloner candidateEventCloner) {
        Object[] obj;
        if (this.expressionExecutorList != null) {
            obj = new Object[this.expressionExecutorList.size()];
            int count = 0;
            for (ExpressionExecutor expressionExecutor : this.expressionExecutorList) {
                boolean mightContain;
                Object value;
                obj[count] = value = expressionExecutor.execute((ComplexEvent)matchingEvent);
                if (this.isBloomEnabled && !(mightContain = this.dbHandler.getBloomFilters()[this.attributeIndexArray[count]].membershipTest(new Key(value.toString().getBytes())))) {
                    return null;
                }
                ++count;
            }
        } else {
            obj = new Object[]{};
        }
        return this.dbHandler.selectEvent(obj, this.executionInfo);
    }

    public boolean contains(StateEvent matchingEvent, Object candidateEvents) {
        Object[] obj;
        if (this.expressionExecutorList != null) {
            obj = new Object[this.expressionExecutorList.size()];
            int count = 0;
            for (ExpressionExecutor expressionExecutor : this.expressionExecutorList) {
                boolean mightContain;
                Object value;
                obj[count] = value = expressionExecutor.execute((ComplexEvent)matchingEvent);
                if (this.isBloomEnabled && !(mightContain = this.dbHandler.getBloomFilters()[this.attributeIndexArray[count]].membershipTest(new Key(value.toString().getBytes())))) {
                    return false;
                }
                ++count;
            }
        } else {
            obj = new Object[]{};
        }
        return this.dbHandler.checkExistence(obj, this.executionInfo);
    }

    public Operator getInMemoryEventTableOperator() {
        return this.inMemoryEventTableOperator;
    }

    private static int getAttributeIndex(DBHandler dbHandler, String attributeName) {
        int i = 0;
        for (Attribute attribute : dbHandler.getAttributeList()) {
            if (attribute.getName().equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

