/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.rdbms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.extension.eventtable.cache.CachingTable;
import org.wso2.siddhi.extension.eventtable.rdbms.DBHandler;
import org.wso2.siddhi.extension.eventtable.rdbms.ExecutionInfo;
import org.wso2.siddhi.extension.eventtable.rdbms.RDBMSOperator;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.And;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.condition.IsNull;
import org.wso2.siddhi.query.api.expression.condition.Not;
import org.wso2.siddhi.query.api.expression.condition.Or;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.expression.constant.DoubleConstant;
import org.wso2.siddhi.query.api.expression.constant.FloatConstant;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.expression.constant.LongConstant;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;

public class RDBMSOperatorParser {
    private static final Log log = LogFactory.getLog(RDBMSOperatorParser.class);

    private RDBMSOperatorParser() {
    }

    public static Operator parse(DBHandler dbHandler, Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap, TableDefinition tableDefinition, CachingTable cachingTable, String queryName) {
        ExecutionInfo executionInfo = dbHandler.getExecutionInfoInstance();
        Map<String, String> elementMappings = dbHandler.getElementMappings();
        String tableName = dbHandler.getTableName();
        ArrayList<Attribute> conditionAttributeList = new ArrayList<Attribute>();
        ArrayList<Attribute> updateConditionAttributeList = new ArrayList<Attribute>();
        updateConditionAttributeList.addAll(matchingMetaStateHolder.getMatchingStreamDefinition().getAttributeList());
        ArrayList<ExpressionExecutor> expressionExecutorList = new ArrayList<ExpressionExecutor>();
        StringBuilder conditionBuilder = new StringBuilder(" ");
        HashMap<String, Boolean> isTableStreamMap = new HashMap<String, Boolean>();
        for (MetaStreamEvent metaStreamEvent : matchingMetaStateHolder.getMetaStateEvent().getMetaStreamEvents()) {
            String referenceId = metaStreamEvent.getInputReferenceId();
            AbstractDefinition abstractDefinition = metaStreamEvent.getLastInputDefinition();
            if (abstractDefinition.getId().trim().equals("")) continue;
            if (abstractDefinition instanceof TableDefinition) {
                isTableStreamMap.put(abstractDefinition.getId(), true);
                if (referenceId == null) continue;
                isTableStreamMap.put(referenceId, true);
                continue;
            }
            isTableStreamMap.put(abstractDefinition.getId(), false);
            if (referenceId == null) continue;
            isTableStreamMap.put(referenceId, false);
        }
        RDBMSOperatorParser.buildConditionQuery(isTableStreamMap, expression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, (MetaComplexEvent)matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, executionInfo, queryName);
        String deleteTableRowQuery = dbHandler.constructQuery(tableName, elementMappings.get("deleteTableRow"), null, null, null, null, conditionBuilder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding SQL Prepared Statement for execution plan " + executionPlanContext.getName() + " : " + deleteTableRowQuery));
        }
        executionInfo.setPreparedDeleteStatement(deleteTableRowQuery);
        executionInfo.setDeleteQueryColumnOrder(conditionAttributeList);
        StringBuilder updateColumnValues = RDBMSOperatorParser.getUpdateQueryAttributes(updateConditionAttributeList, dbHandler.getElementMappings());
        String updateTableRowQuery = dbHandler.constructQuery(tableName, elementMappings.get("updateTableRow"), null, null, null, updateColumnValues, conditionBuilder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding SQL Prepared Statement for execution plan " + executionPlanContext.getName() + " : " + updateTableRowQuery));
        }
        executionInfo.setPreparedUpdateStatement(updateTableRowQuery);
        updateConditionAttributeList.addAll(conditionAttributeList);
        executionInfo.setUpdateQueryColumnOrder(updateConditionAttributeList);
        String selectTableRowQuery = dbHandler.constructQuery(tableName, elementMappings.get("selectTableRow"), null, null, null, null, conditionBuilder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding SQL Prepared Statement for execution plan " + executionPlanContext.getName() + " : " + selectTableRowQuery));
        }
        executionInfo.setPreparedSelectTableStatement(selectTableRowQuery);
        executionInfo.setConditionQueryColumnOrder(conditionAttributeList);
        String isTableRowExistentQuery = dbHandler.constructQuery(tableName, elementMappings.get("isTableRowExist"), null, null, null, null, conditionBuilder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding SQL Prepared Statement for execution plan " + executionPlanContext.getName() + " : " + isTableRowExistentQuery));
        }
        executionInfo.setPreparedTableRowExistenceCheckStatement(isTableRowExistentQuery);
        executionInfo.setConditionQueryColumnOrder(conditionAttributeList);
        Operator inMemoryEventTableOperator = null;
        if (cachingTable != null) {
            inMemoryEventTableOperator = OperatorParser.constructOperator(cachingTable.getCacheList(), (Expression)expression, (MatchingMetaStateHolder)matchingMetaStateHolder, (ExecutionPlanContext)executionPlanContext, variableExpressionExecutors, eventTableMap, (String)queryName);
        }
        return new RDBMSOperator(executionInfo, expressionExecutorList, dbHandler, inMemoryEventTableOperator, matchingMetaStateHolder.getMatchingStreamDefinition().getAttributeList().size());
    }

    private static Attribute getAttribute(DBHandler dbHandler, String attributeName) {
        for (Attribute attribute : dbHandler.getAttributeList()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    private static StringBuilder getUpdateQueryAttributes(List<Attribute> updateConditionAttributeList, Map<String, String> elementMappings) {
        StringBuilder columnValues = new StringBuilder(" ");
        boolean appendComma = false;
        for (Attribute at : updateConditionAttributeList) {
            if (appendComma) {
                columnValues.append(" ").append(elementMappings.get("comma")).append(" ");
            }
            columnValues.append(at.getName());
            columnValues.append(" ").append(elementMappings.get("equal")).append(" ").append(elementMappings.get("questionMark")).append(" ");
            appendComma = true;
        }
        return columnValues;
    }

    private static void buildConditionQuery(Map<String, Boolean> isTableStreamMap, Expression expression, StringBuilder conditionBuilder, List<Attribute> conditionAttributeList, List<ExpressionExecutor> expressionExecutorList, DBHandler dbHandler, Map<String, String> elementMappings, MetaComplexEvent metaStateEvent, int matchingStreamIndex, Map<String, EventTable> eventTableMap, List<VariableExpressionExecutor> variableExpressionExecutors, ExecutionPlanContext executionPlanContext, ExecutionInfo executionInfo, String queryName) {
        if (expression instanceof And) {
            Expression leftExpression = ((And)expression).getLeftExpression();
            RDBMSOperatorParser.buildConditionQuery(isTableStreamMap, leftExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, executionInfo, queryName);
            conditionBuilder.append(" ").append(elementMappings.get("and")).append(" ");
            Expression rightExpression = ((And)expression).getRightExpression();
            RDBMSOperatorParser.buildConditionQuery(isTableStreamMap, rightExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, executionInfo, queryName);
        } else if (expression instanceof Or) {
            Expression leftExpression = ((Or)expression).getLeftExpression();
            RDBMSOperatorParser.buildConditionQuery(isTableStreamMap, leftExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, executionInfo, queryName);
            conditionBuilder.append(" ").append(elementMappings.get("or")).append(" ");
            Expression rightExpression = ((Or)expression).getRightExpression();
            RDBMSOperatorParser.buildConditionQuery(isTableStreamMap, rightExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, executionInfo, queryName);
        } else if (expression instanceof Not) {
            Expression rightExpression = ((Not)expression).getExpression();
            conditionBuilder.append(" ").append(elementMappings.get("not")).append(" ");
            RDBMSOperatorParser.buildConditionQuery(isTableStreamMap, rightExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, executionInfo, queryName);
        } else if (expression instanceof IsNull) {
            Boolean isEvenTable;
            Expression leftExpression = ((IsNull)expression).getExpression();
            String streamId = ((Variable)leftExpression).getStreamId();
            if (streamId != null && (isEvenTable = isTableStreamMap.get(streamId)) != null && isEvenTable.booleanValue()) {
                RDBMSOperatorParser.setEventTableVariableAttribute(leftExpression, conditionBuilder);
                conditionBuilder.append(elementMappings.get("isNull")).append(" ");
            }
        } else if (expression instanceof Compare) {
            Expression leftExpression = ((Compare)expression).getLeftExpression();
            Expression rightExpression = ((Compare)expression).getRightExpression();
            boolean isLeftExpressionEventTable = false;
            if (leftExpression instanceof Variable) {
                String streamId = ((Variable)leftExpression).getStreamId();
                if (streamId == null && rightExpression instanceof Constant) {
                    RDBMSOperatorParser.setEventTableVariableAttribute(leftExpression, conditionBuilder);
                    isLeftExpressionEventTable = true;
                } else if (streamId != null) {
                    Boolean isEvenTable = isTableStreamMap.get(streamId);
                    if (isEvenTable != null) {
                        if (isEvenTable.booleanValue()) {
                            RDBMSOperatorParser.setEventTableVariableAttribute(leftExpression, conditionBuilder);
                            isLeftExpressionEventTable = true;
                        } else {
                            RDBMSOperatorParser.setExpressionExecutor(rightExpression, leftExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, queryName);
                            isLeftExpressionEventTable = false;
                        }
                    }
                } else {
                    RDBMSOperatorParser.setExpressionExecutor(rightExpression, leftExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, queryName);
                    isLeftExpressionEventTable = false;
                }
            } else if (leftExpression instanceof Constant) {
                RDBMSOperatorParser.setConstantValue(leftExpression, conditionBuilder);
                isLeftExpressionEventTable = false;
            }
            if (((Compare)expression).getOperator().equals((Object)Compare.Operator.EQUAL)) {
                executionInfo.setIsBloomFilterCompatible(true);
                conditionBuilder.append(elementMappings.get("equal")).append(" ");
            } else if (((Compare)expression).getOperator().equals((Object)Compare.Operator.GREATER_THAN)) {
                executionInfo.setIsBloomFilterCompatible(false);
                conditionBuilder.append(elementMappings.get("greaterThan")).append(" ");
            } else if (((Compare)expression).getOperator().equals((Object)Compare.Operator.LESS_THAN)) {
                executionInfo.setIsBloomFilterCompatible(false);
                conditionBuilder.append(elementMappings.get("lessThan")).append(" ");
            } else if (((Compare)expression).getOperator().equals((Object)Compare.Operator.GREATER_THAN_EQUAL)) {
                executionInfo.setIsBloomFilterCompatible(false);
                conditionBuilder.append(elementMappings.get("greaterThanEqual")).append(" ");
            } else if (((Compare)expression).getOperator().equals((Object)Compare.Operator.LESS_THAN_EQUAL)) {
                executionInfo.setIsBloomFilterCompatible(false);
                conditionBuilder.append(elementMappings.get("lessThanEqual")).append(" ");
            } else if (((Compare)expression).getOperator().equals((Object)Compare.Operator.NOT_EQUAL)) {
                executionInfo.setIsBloomFilterCompatible(false);
                conditionBuilder.append(elementMappings.get("notEqual")).append(" ");
            }
            if (isLeftExpressionEventTable) {
                if (rightExpression instanceof Variable) {
                    RDBMSOperatorParser.setExpressionExecutor(leftExpression, rightExpression, conditionBuilder, conditionAttributeList, expressionExecutorList, dbHandler, elementMappings, metaStateEvent, matchingStreamIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, queryName);
                } else if (rightExpression instanceof Constant) {
                    RDBMSOperatorParser.setConstantValue(rightExpression, conditionBuilder);
                }
            } else {
                RDBMSOperatorParser.setEventTableVariableAttribute(rightExpression, conditionBuilder);
            }
        }
    }

    private static void setEventTableVariableAttribute(Expression expression, StringBuilder conditionBuilder) {
        String attributeName = ((Variable)expression).getAttributeName();
        conditionBuilder.append(attributeName).append(" ");
    }

    private static void setExpressionExecutor(Expression eventTableExpression, Expression expression, StringBuilder conditionBuilder, List<Attribute> conditionAttributeList, List<ExpressionExecutor> expressionExecutorList, DBHandler dbHandler, Map<String, String> elementMappings, MetaComplexEvent metaStateEvent, int matchingStreamIndex, Map<String, EventTable> eventTableMap, List<VariableExpressionExecutor> variableExpressionExecutors, ExecutionPlanContext executionPlanContext, String queryName) {
        ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression((Expression)expression, (MetaComplexEvent)metaStateEvent, (int)matchingStreamIndex, eventTableMap, variableExpressionExecutors, (ExecutionPlanContext)executionPlanContext, (boolean)false, (int)0, (String)queryName);
        conditionBuilder.append(elementMappings.get("questionMark")).append(" ");
        String attributeName = ((Variable)eventTableExpression).getAttributeName();
        conditionAttributeList.add(RDBMSOperatorParser.getAttribute(dbHandler, attributeName));
        expressionExecutorList.add(expressionExecutor);
    }

    private static void setConstantValue(Expression expression, StringBuilder conditionBuilder) {
        if (expression instanceof StringConstant) {
            String value = ((StringConstant)expression).getValue();
            conditionBuilder.append("'").append(value).append("'");
        } else if (expression instanceof IntConstant) {
            int value = ((IntConstant)expression).getValue();
            conditionBuilder.append(value);
        } else if (expression instanceof FloatConstant) {
            float value = ((FloatConstant)expression).getValue().floatValue();
            conditionBuilder.append(value);
        } else if (expression instanceof LongConstant) {
            long value = ((LongConstant)expression).getValue();
            conditionBuilder.append(value);
        } else if (expression instanceof DoubleConstant) {
            double value = ((DoubleConstant)expression).getValue();
            conditionBuilder.append(value);
        } else if (expression instanceof BoolConstant) {
            boolean value = ((BoolConstant)expression).getValue();
            conditionBuilder.append(value ? "TRUE" : "FALSE");
        }
    }
}

