/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.cache;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.extension.eventtable.cache.CacheManager;

public class LFUCacheManager
implements CacheManager {
    private ConcurrentHashMap<StreamEvent, Integer> eventAccessFrequencies = new ConcurrentHashMap();
    private final LinkedList<StreamEvent> cacheList;
    private long limit;

    public LFUCacheManager(LinkedList<StreamEvent> cacheList, long limit) {
        this.cacheList = cacheList;
        this.limit = limit;
    }

    @Override
    public void add(StreamEvent item) {
        this.eventAccessFrequencies.put(item, 1);
        if ((long)this.eventAccessFrequencies.size() >= this.limit) {
            StreamEvent leastFrequentItem = null;
            Integer leastFrequency = Integer.MAX_VALUE;
            for (Map.Entry<StreamEvent, Integer> entry : this.eventAccessFrequencies.entrySet()) {
                if (leastFrequency <= entry.getValue()) continue;
                leastFrequency = entry.getValue();
                leastFrequentItem = entry.getKey();
            }
            this.eventAccessFrequencies.remove(leastFrequentItem);
            this.cacheList.remove(leastFrequentItem);
        }
    }

    @Override
    public void delete(StreamEvent item) {
        this.eventAccessFrequencies.remove(item);
    }

    @Override
    public void read(StreamEvent item) {
        Integer currentAccessAttempts = this.eventAccessFrequencies.get(item);
        if (currentAccessAttempts != null) {
            this.eventAccessFrequencies.put(item, currentAccessAttempts + 1);
        }
    }

    @Override
    public void update(StreamEvent item) {
        Integer currentAccessAttempts = this.eventAccessFrequencies.get(item);
        if (currentAccessAttempts != null) {
            this.eventAccessFrequencies.put(item, currentAccessAttempts + 1);
        }
    }

    @Override
    public void invalidateCache() {
        this.cacheList.clear();
    }

    @Override
    public boolean isContains(StreamEvent item) {
        return this.eventAccessFrequencies.contains(item);
    }
}

