/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.cache;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.extension.eventtable.cache.CacheManager;

public class LRUCacheManager
implements CacheManager {
    private ConcurrentHashMap<StreamEvent, Long> eventTimestamps = new ConcurrentHashMap();
    private final LinkedList<StreamEvent> cacheList;
    private long limit;

    public LRUCacheManager(LinkedList<StreamEvent> cacheList, long limit) {
        this.cacheList = cacheList;
        this.limit = limit;
    }

    @Override
    public void add(StreamEvent item) {
        this.eventTimestamps.put(item, System.currentTimeMillis());
        if ((long)this.eventTimestamps.size() >= this.limit) {
            StreamEvent leastRecent = null;
            long leastRecentTime = Long.MAX_VALUE;
            for (Map.Entry<StreamEvent, Long> entry : this.eventTimestamps.entrySet()) {
                if (leastRecentTime <= entry.getValue()) continue;
                leastRecentTime = entry.getValue();
                leastRecent = entry.getKey();
            }
            this.eventTimestamps.remove(leastRecent);
            this.cacheList.remove(leastRecent);
        }
    }

    @Override
    public void delete(StreamEvent item) {
        this.eventTimestamps.remove(item);
    }

    @Override
    public void read(StreamEvent item) {
        this.eventTimestamps.put(item, System.currentTimeMillis());
    }

    @Override
    public void update(StreamEvent item) {
        this.eventTimestamps.put(item, System.currentTimeMillis());
    }

    @Override
    public void invalidateCache() {
        this.cacheList.clear();
    }

    @Override
    public boolean isContains(StreamEvent item) {
        return this.cacheList.contains(item);
    }
}

