/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.bloom.CountingBloomFilter;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.extension.eventtable.cache.CachingTable;
import org.wso2.siddhi.extension.eventtable.rdbms.BloomFilterImpl;
import org.wso2.siddhi.extension.eventtable.rdbms.DBQueryHelper;
import org.wso2.siddhi.extension.eventtable.rdbms.ExecutionInfo;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.TableDefinition;

public class DBHandler {
    private static final Log log = LogFactory.getLog(DBHandler.class);
    private String tableName;
    private Map<String, String> elementMappings;
    private ExecutionInfo executionInfo;
    private List<Attribute> attributeList;
    private DataSource dataSource;
    private boolean isBloomFilterEnabled;
    private BloomFilterImpl bloomFilterImpl;
    private TableDefinition tableDefinition;
    private CachingTable cachingTable;

    public DBHandler(DataSource dataSource, String tableName, List<Attribute> attributeList, TableDefinition tableDefinition) {
        Connection con = null;
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.attributeList = attributeList;
        this.tableDefinition = tableDefinition;
        this.executionInfo = new ExecutionInfo();
        try {
            con = dataSource.getConnection();
            this.initializeDatabaseExecutionInfo(this.executionInfo);
            this.initializeConnection();
        }
        catch (SQLException e) {
            throw new ExecutionPlanRuntimeException("Error while initialising the connection, " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanUpConnections(null, con);
        }
    }

    public ExecutionInfo getExecutionInfoInstance() {
        ExecutionInfo executionInfo = new ExecutionInfo();
        this.initializeDatabaseExecutionInfo(executionInfo);
        return executionInfo;
    }

    public Map<String, String> getElementMappings() {
        return this.elementMappings;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public boolean isBloomFilterEnabled() {
        return this.isBloomFilterEnabled;
    }

    public void addEvent(ComplexEventChunk addingEventChunk) {
        addingEventChunk.reset();
        PreparedStatement stmt = null;
        Connection con = null;
        ArrayList<ComplexEvent> eventArrayList = new ArrayList<ComplexEvent>();
        try {
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(this.executionInfo.getPreparedInsertStatement());
            con.setAutoCommit(false);
            while (addingEventChunk.hasNext()) {
                ComplexEvent complexEvent = addingEventChunk.next();
                eventArrayList.add(complexEvent);
                this.populateStatement(complexEvent.getOutputData(), stmt, this.executionInfo.getInsertQueryColumnOrder());
                stmt.addBatch();
            }
            if (eventArrayList.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation: addEvent, Add Event Statement: " + stmt));
                }
                stmt.executeBatch();
                con.commit();
                for (ComplexEvent complexEvent : eventArrayList) {
                    if (this.cachingTable == null) continue;
                    this.cachingTable.add(complexEvent);
                }
                if (this.isBloomFilterEnabled) {
                    for (ComplexEvent event : eventArrayList) {
                        this.bloomFilterImpl.addToBloomFilters(event);
                    }
                }
            }
            this.cleanUpConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                throw new ExecutionPlanRuntimeException("Error while adding events to event table, " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(stmt, con);
                throw throwable;
            }
        }
    }

    public void deleteEvent(List<Object[]> eventList, ExecutionInfo executionInfo) {
        PreparedStatement deletionPreparedStatement = null;
        PreparedStatement selectionPreparedStatement = null;
        ArrayList<Object[]> selectedEventList = new ArrayList<Object[]>();
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            deletionPreparedStatement = con.prepareStatement(executionInfo.getPreparedDeleteStatement());
            selectionPreparedStatement = con.prepareStatement(executionInfo.getPreparedSelectTableStatement());
            con.setAutoCommit(false);
            for (Object[] obj : eventList) {
                this.populateStatement(obj, deletionPreparedStatement, executionInfo.getDeleteQueryColumnOrder());
                deletionPreparedStatement.addBatch();
                this.populateStatement(obj, selectionPreparedStatement, executionInfo.getConditionQueryColumnOrder());
                if (selectionPreparedStatement == null || !this.isBloomFilterEnabled) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation: deleteEvent, Selection Statement: " + selectionPreparedStatement));
                }
                ResultSet resultSet = selectionPreparedStatement.executeQuery();
                this.populateEventListFromResultSet(selectedEventList, resultSet);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: deleteEvent, Deletion Statement: " + deletionPreparedStatement));
            }
            int[] deletedRows = deletionPreparedStatement.executeBatch();
            con.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)(deletedRows.length + " rows deleted in table " + this.tableName));
            }
            if (this.isBloomFilterEnabled && deletedRows != null && deletedRows.length > 0) {
                for (Object[] obj : selectedEventList) {
                    this.bloomFilterImpl.removeFromBloomFilters(obj);
                }
            }
            this.cleanUpConnections(deletionPreparedStatement, con);
            this.cleanUpConnections(selectionPreparedStatement, con);
        }
        catch (SQLException e) {
            try {
                throw new ExecutionPlanRuntimeException("Error while deleting events from database," + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(deletionPreparedStatement, con);
                this.cleanUpConnections(selectionPreparedStatement, con);
                throw throwable;
            }
        }
    }

    public void updateEvent(List<Object[]> updateEventList, ExecutionInfo executionInfo) {
        PreparedStatement updatePreparedStatement = null;
        PreparedStatement selectionPreparedStatement = null;
        ArrayList<Object[]> selectedEventList = new ArrayList<Object[]>();
        Connection con = null;
        int[] updatedRows = null;
        int conditionArrayStartIndex = executionInfo.getUpdateQueryColumnOrder().size() - executionInfo.getConditionQueryColumnOrder().size();
        try {
            con = this.dataSource.getConnection();
            updatePreparedStatement = con.prepareStatement(executionInfo.getPreparedUpdateStatement());
            selectionPreparedStatement = con.prepareStatement(executionInfo.getPreparedSelectTableStatement());
            con.setAutoCommit(false);
            for (Object[] obj : updateEventList) {
                this.populateStatement(obj, updatePreparedStatement, executionInfo.getUpdateQueryColumnOrder());
                updatePreparedStatement.addBatch();
                this.populateStatement(Arrays.copyOfRange(obj, conditionArrayStartIndex, obj.length), selectionPreparedStatement, executionInfo.getConditionQueryColumnOrder());
                if (selectionPreparedStatement == null || !this.isBloomFilterEnabled) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation: updateEvent, Selection Statement: " + selectionPreparedStatement));
                }
                ResultSet resultSet = selectionPreparedStatement.executeQuery();
                this.populateEventListFromResultSet(selectedEventList, resultSet);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: updateEvent, Update Statement: " + updatePreparedStatement));
            }
            updatedRows = updatePreparedStatement.executeBatch();
            con.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)(updatedRows.length + " updated in table " + this.tableName));
            }
            this.cleanUpConnections(updatePreparedStatement, con);
            this.cleanUpConnections(selectionPreparedStatement, con);
        }
        catch (SQLException e) {
            try {
                throw new ExecutionPlanRuntimeException("Error while updating events in database," + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(updatePreparedStatement, con);
                this.cleanUpConnections(selectionPreparedStatement, con);
                throw throwable;
            }
        }
        if (this.isBloomFilterEnabled && updatedRows != null && updatedRows.length > 0) {
            for (Object[] obj : selectedEventList) {
                this.bloomFilterImpl.removeFromBloomFilters(obj);
            }
            for (Object[] obj : updateEventList) {
                this.bloomFilterImpl.addToBloomFilters(obj);
            }
        }
    }

    public void overwriteOrAddEvent(List<Object[]> updateEventList, ExecutionInfo executionInfo) {
        PreparedStatement updatePreparedStatement = null;
        PreparedStatement insertionPreparedStatement = null;
        PreparedStatement selectionPreparedStatement = null;
        ArrayList<Object[]> selectedEventList = new ArrayList<Object[]>();
        Connection con = null;
        int conditionArrayStartIndex = executionInfo.getUpdateQueryColumnOrder().size() - executionInfo.getConditionQueryColumnOrder().size();
        boolean isInserted = false;
        try {
            con = this.dataSource.getConnection();
            updatePreparedStatement = con.prepareStatement(executionInfo.getPreparedUpdateStatement());
            insertionPreparedStatement = con.prepareStatement(executionInfo.getPreparedInsertStatement());
            selectionPreparedStatement = con.prepareStatement(executionInfo.getPreparedSelectTableStatement());
            con.setAutoCommit(false);
            for (Object[] obj : updateEventList) {
                this.populateStatement(obj, updatePreparedStatement, executionInfo.getUpdateQueryColumnOrder());
                updatePreparedStatement.addBatch();
                this.populateStatement(Arrays.copyOfRange(obj, conditionArrayStartIndex, obj.length), selectionPreparedStatement, executionInfo.getConditionQueryColumnOrder());
                if (selectionPreparedStatement == null || !this.isBloomFilterEnabled) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation: overwriteOrAddEvent, Selection Statement: " + selectionPreparedStatement));
                }
                ResultSet resultSet = selectionPreparedStatement.executeQuery();
                this.populateEventListFromResultSet(selectedEventList, resultSet);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: overwriteOrAddEvent, Update Statement: " + updatePreparedStatement));
            }
            int[] updatedRows = updatePreparedStatement.executeBatch();
            for (int i = 0; i < updatedRows.length; ++i) {
                int isUpdated = updatedRows[i];
                if (isUpdated != 0) continue;
                isInserted = true;
                Object[] updateEvent = updateEventList.get(i);
                this.populateStatement(updateEvent, insertionPreparedStatement, executionInfo.getInsertQueryColumnOrder());
                insertionPreparedStatement.addBatch();
                if (!this.isBloomFilterEnabled) continue;
                this.bloomFilterImpl.addToBloomFilters(updateEvent);
            }
            if (isInserted) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation: overwriteOrAddEvent, Insertion Statement: " + insertionPreparedStatement));
                }
                insertionPreparedStatement.executeBatch();
            }
            con.commit();
            if (this.isBloomFilterEnabled) {
                for (Object[] obj : selectedEventList) {
                    this.bloomFilterImpl.removeFromBloomFilters(obj);
                }
                for (Object[] obj : updateEventList) {
                    this.bloomFilterImpl.addToBloomFilters(obj);
                }
            }
            this.cleanUpConnections(updatePreparedStatement, con);
            this.cleanUpConnections(insertionPreparedStatement, con);
            this.cleanUpConnections(selectionPreparedStatement, con);
        }
        catch (SQLException e) {
            try {
                throw new ExecutionPlanRuntimeException("Error while insertOrOverwriting events from database," + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(updatePreparedStatement, con);
                this.cleanUpConnections(insertionPreparedStatement, con);
                this.cleanUpConnections(selectionPreparedStatement, con);
                throw throwable;
            }
        }
    }

    public StreamEvent selectEvent(Object[] obj, ExecutionInfo executionInfo) {
        PreparedStatement stmt = null;
        Connection con = null;
        ComplexEventChunk returnEventChunk = new ComplexEventChunk(false);
        try {
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(executionInfo.getPreparedSelectTableStatement());
            this.populateStatement(obj, stmt, executionInfo.getConditionQueryColumnOrder());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: selectEvent, Select Statement: " + stmt));
            }
            ResultSet resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Object[] data = new Object[this.attributeList.size()];
                block13: for (int i = 0; i < this.attributeList.size(); ++i) {
                    switch (this.attributeList.get(i).getType()) {
                        case BOOL: {
                            data[i] = resultSet.getBoolean(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case DOUBLE: {
                            data[i] = resultSet.getDouble(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case FLOAT: {
                            data[i] = Float.valueOf(resultSet.getFloat(this.attributeList.get(i).getName()));
                            continue block13;
                        }
                        case INT: {
                            data[i] = resultSet.getInt(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case LONG: {
                            data[i] = resultSet.getLong(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case STRING: {
                            data[i] = resultSet.getString(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        default: {
                            data[i] = resultSet.getObject(this.attributeList.get(i).getName());
                        }
                    }
                }
                StreamEvent streamEvent = new StreamEvent(0, 0, this.attributeList.size());
                streamEvent.setOutputData(data);
                returnEventChunk.add((ComplexEvent)streamEvent);
            }
            this.cleanUpConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                throw new ExecutionPlanRuntimeException("Error while retrieving events from event table, " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(stmt, con);
                throw throwable;
            }
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    public boolean checkExistence(Object[] obj, ExecutionInfo executionInfo) {
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            ResultSet resultSet;
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(executionInfo.getPreparedTableRowExistenceCheckStatement());
            this.populateStatement(obj, stmt, executionInfo.getConditionQueryColumnOrder());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: checkExistence, Check Existence Statement: " + stmt));
            }
            if ((resultSet = stmt.executeQuery()).next()) {
                this.cleanUpConnections(stmt, con);
                boolean bl = true;
                this.cleanUpConnections(stmt, con);
                return bl;
            }
            this.cleanUpConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                throw new ExecutionPlanRuntimeException("Error while retrieving events from event table, " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(stmt, con);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConnection() {
        Statement stmt = null;
        Boolean tableExists = true;
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            stmt = con.createStatement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: initializeConnection, Table Existence Check Query: " + this.executionInfo.getPreparedTableExistenceCheckStatement()));
            }
            stmt.executeQuery(this.executionInfo.getPreparedTableExistenceCheckStatement());
            this.cleanUpConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                tableExists = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Table " + this.tableName + " does not Exist. Table Will be created. "));
                }
                this.cleanUpConnections(stmt, con);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(stmt, con);
                throw throwable;
            }
        }
        try {
            if (!tableExists.booleanValue()) {
                con = this.dataSource.getConnection();
                stmt = con.createStatement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operation: initializeConnection, Create Table Statement: " + this.executionInfo.getPreparedCreateTableStatement()));
                }
                stmt.executeUpdate(this.executionInfo.getPreparedCreateTableStatement());
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
        }
        catch (SQLException e) {
            block18: {
                try {
                    if (con != null && !con.getAutoCommit()) {
                        con.rollback();
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)("Table " + this.tableName + " Creation Failed. Transaction rollback error "), (Throwable)ex);
                }
            }
            throw new ExecutionPlanRuntimeException("Exception while creating the event table, " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanUpConnections(stmt, con);
        }
    }

    private void populateStatement(Object[] o, PreparedStatement stmt, List<Attribute> colOrder) {
        Attribute attribute = null;
        try {
            for (int i = 0; i < colOrder.size(); ++i) {
                attribute = colOrder.get(i);
                Object value = o[i];
                if (value != null || attribute.getType() == Attribute.Type.STRING) {
                    switch (attribute.getType()) {
                        case INT: {
                            stmt.setInt(i + 1, (Integer)value);
                            break;
                        }
                        case LONG: {
                            stmt.setLong(i + 1, (Long)value);
                            break;
                        }
                        case FLOAT: {
                            stmt.setFloat(i + 1, ((Float)value).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            stmt.setDouble(i + 1, (Double)value);
                            break;
                        }
                        case STRING: {
                            stmt.setString(i + 1, (String)value);
                            break;
                        }
                        case BOOL: {
                            stmt.setBoolean(i + 1, (Boolean)value);
                        }
                    }
                    continue;
                }
                throw new ExecutionPlanRuntimeException("Cannot Execute Insert/Update. Null value detected for attribute '" + attribute.getName() + "'");
            }
        }
        catch (SQLException e) {
            throw new ExecutionPlanRuntimeException("Cannot set value to attribute name " + attribute.getName() + ". Hence dropping the event. " + e.getMessage(), (Throwable)e);
        }
    }

    private List<Object[]> populateEventListFromResultSet(List<Object[]> selectedEventList, ResultSet results) {
        int columnCount = this.tableDefinition.getAttributeList().size();
        try {
            while (results.next()) {
                Object[] eventArray = new Object[columnCount];
                block11: for (int i = 0; i < columnCount; ++i) {
                    switch (((Attribute)this.tableDefinition.getAttributeList().get(i)).getType()) {
                        case INT: {
                            eventArray[i] = results.getInt(i + 1);
                            continue block11;
                        }
                        case LONG: {
                            eventArray[i] = results.getLong(i + 1);
                            continue block11;
                        }
                        case FLOAT: {
                            eventArray[i] = Float.valueOf(results.getFloat(i + 1));
                            continue block11;
                        }
                        case DOUBLE: {
                            eventArray[i] = results.getDouble(i + 1);
                            continue block11;
                        }
                        case STRING: {
                            eventArray[i] = results.getString(i + 1);
                            continue block11;
                        }
                        case BOOL: {
                            eventArray[i] = results.getBoolean(i + 1);
                        }
                    }
                }
                selectedEventList.add(eventArray);
            }
            results.close();
        }
        catch (SQLException e) {
            throw new ExecutionPlanRuntimeException("Error while populating event list from db result set," + e.getMessage(), (Throwable)e);
        }
        return selectedEventList;
    }

    private void initializeDatabaseExecutionInfo(ExecutionInfo executionInfo) {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            String databaseType = databaseMetaData.getDatabaseProductName();
            this.elementMappings = DBQueryHelper.getDbTypeMappings().get(databaseType.toLowerCase());
            if (this.elementMappings == null) {
                this.elementMappings = DBQueryHelper.getDbTypeMappings().get("default");
            }
            StringBuilder columnTypes = new StringBuilder("");
            StringBuilder columns = new StringBuilder("");
            StringBuilder valuePositionsBuilder = new StringBuilder("");
            boolean appendComma = false;
            for (Attribute attribute : this.attributeList) {
                String columnName = attribute.getName().toUpperCase();
                if (appendComma) {
                    columnTypes.append(this.elementMappings.get("comma"));
                }
                columnTypes.append(columnName).append("  ");
                if (attribute.getType().equals((Object)Attribute.Type.INT)) {
                    columnTypes.append(this.elementMappings.get("integer"));
                } else if (attribute.getType().equals((Object)Attribute.Type.LONG)) {
                    columnTypes.append(this.elementMappings.get("long"));
                } else if (attribute.getType().equals((Object)Attribute.Type.FLOAT)) {
                    columnTypes.append(this.elementMappings.get("float"));
                } else if (attribute.getType().equals((Object)Attribute.Type.DOUBLE)) {
                    columnTypes.append(this.elementMappings.get("double"));
                } else if (attribute.getType().equals((Object)Attribute.Type.STRING)) {
                    columnTypes.append(this.elementMappings.get("string"));
                } else if (attribute.getType().equals((Object)Attribute.Type.BOOL)) {
                    columnTypes.append(this.elementMappings.get("bool"));
                }
                if (appendComma) {
                    columns.append(this.elementMappings.get("comma"));
                    valuePositionsBuilder.append(this.elementMappings.get("comma"));
                } else {
                    appendComma = true;
                }
                columns.append(attribute.getName());
                valuePositionsBuilder.append(this.elementMappings.get("questionMark"));
            }
            String createTableQuery = this.constructQuery(this.tableName, this.elementMappings.get("createTable"), columnTypes, null, null, null, null);
            String insertTableRowQuery = this.constructQuery(this.tableName, this.elementMappings.get("insertDataToTable"), null, columns, valuePositionsBuilder, null, null);
            String isTableExistQuery = this.constructQuery(this.tableName, this.elementMappings.get("isTableExist"), null, null, null, null, null);
            executionInfo.setPreparedInsertStatement(insertTableRowQuery);
            executionInfo.setPreparedCreateTableStatement(createTableQuery);
            executionInfo.setInsertQueryColumnOrder(this.attributeList);
            executionInfo.setPreparedTableExistenceCheckStatement(isTableExistQuery);
        }
        catch (SQLException e) {
            throw new ExecutionPlanRuntimeException("Error while accessing through datasource connection, " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanUpConnections(null, con);
        }
    }

    public String constructQuery(String tableName, String query, StringBuilder columnTypes, StringBuilder columns, StringBuilder values, StringBuilder column_values, StringBuilder condition) {
        if (query.contains("$TABLE_NAME")) {
            query = query.replace("$TABLE_NAME", tableName);
        }
        if (query.contains("$COLUMN_TYPES")) {
            query = query.replace("$COLUMN_TYPES", columnTypes.toString());
        }
        if (query.contains("$COLUMNS")) {
            query = query.replace("$COLUMNS", columns.toString());
        }
        if (query.contains("$VALUES")) {
            query = query.replace("$VALUES", values.toString());
        }
        if (query.contains("$COLUMN_VALUES")) {
            query = query.replace("$COLUMN_VALUES", column_values.toString());
        }
        if (query.contains("$CONDITION")) {
            query = condition == null || condition.toString().trim().equals("") ? query.replace("$CONDITION", "").replace("where", "").replace("WHERE", "") : query.replace("$CONDITION", condition.toString());
        }
        return query;
    }

    private void cleanUpConnections(Statement stmt, Connection con) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ExecutionPlanRuntimeException("unable to release statement, " + e.getMessage(), (Throwable)e);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw new ExecutionPlanRuntimeException("unable to release connection, " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setBloomFilters(int bloomFilterSize, int bloomFilterHashFunction) {
        this.bloomFilterImpl = new BloomFilterImpl(bloomFilterSize, bloomFilterHashFunction, this.attributeList);
        this.isBloomFilterEnabled = true;
    }

    public void buildBloomFilters() {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.dataSource.getConnection();
            stmt = con.createStatement();
            String selectTableRowQuery = this.constructQuery(this.tableName, this.elementMappings.get("selectTableRow"), null, null, null, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: buildBloomFilters, Select Row Query: " + selectTableRowQuery));
            }
            ResultSet results = stmt.executeQuery(selectTableRowQuery);
            this.bloomFilterImpl.buildBloomFilters(results);
            this.cleanUpConnections(stmt, con);
        }
        catch (SQLException ex) {
            try {
                throw new ExecutionPlanRuntimeException("Error while initiating blooms filter with db data, " + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(stmt, con);
                throw throwable;
            }
        }
    }

    public CountingBloomFilter[] getBloomFilters() {
        return this.bloomFilterImpl.getBloomFilters();
    }

    public void loadDBCache(CachingTable cachingTable, String cacheSizeInString) {
        this.cachingTable = cachingTable;
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.dataSource.getConnection();
            stmt = con.createStatement();
            con = this.dataSource.getConnection();
            stmt = con.createStatement();
            String selectTableRowQuery = this.constructQuery(this.tableName, this.elementMappings.get("limitSelectRow"), null, null, new StringBuilder(cacheSizeInString), null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operation: loadDBCache, Select Row Query: " + selectTableRowQuery));
            }
            ResultSet resultSet = stmt.executeQuery(selectTableRowQuery);
            while (resultSet.next()) {
                Object[] data = new Object[this.attributeList.size()];
                block13: for (int i = 0; i < this.attributeList.size(); ++i) {
                    switch (this.attributeList.get(i).getType()) {
                        case BOOL: {
                            data[i] = resultSet.getBoolean(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case DOUBLE: {
                            data[i] = resultSet.getDouble(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case FLOAT: {
                            data[i] = Float.valueOf(resultSet.getFloat(this.attributeList.get(i).getName()));
                            continue block13;
                        }
                        case INT: {
                            data[i] = resultSet.getInt(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case LONG: {
                            data[i] = resultSet.getLong(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        case STRING: {
                            data[i] = resultSet.getString(this.attributeList.get(i).getName());
                            continue block13;
                        }
                        default: {
                            data[i] = resultSet.getObject(this.attributeList.get(i).getName());
                        }
                    }
                }
                StreamEvent streamEvent = new StreamEvent(0, 0, this.attributeList.size());
                streamEvent.setOutputData(data);
                cachingTable.add((ComplexEvent)streamEvent);
            }
            resultSet.close();
            this.cleanUpConnections(stmt, con);
        }
        catch (SQLException ex) {
            try {
                throw new ExecutionPlanRuntimeException("Error while loading cache with db data, " + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.cleanUpConnections(stmt, con);
                throw throwable;
            }
        }
    }
}

