/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.rdbms;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.wso2.siddhi.query.api.annotation.Element;

public class PooledDataSource {
    private static final int maxIdle = 8;
    private static final int minIdle = 0;
    private static final int initialSize = 0;
    private static final int maxActive = 50;
    private static final int maxWait = 60000;
    private static final boolean testOnBorrow = true;
    private static final String validationQuery = "SELECT 1";
    private static final long validationInterval = 30000L;
    private static final boolean defaultAutoCommit = false;
    private static final Log log = LogFactory.getLog(PooledDataSource.class);

    private PooledDataSource() {
    }

    public static DataSource getPoolDataSource(String driver, String url, String username, String password, List<Element> connectionPropertyElements) {
        DataSource dataSource = new DataSource();
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setDriverClassName(driver);
        poolProperties.setUrl(url);
        poolProperties.setUsername(username);
        poolProperties.setPassword(password);
        poolProperties.setMaxIdle(8);
        poolProperties.setMinIdle(0);
        poolProperties.setInitialSize(0);
        poolProperties.setMaxActive(50);
        poolProperties.setMaxWait(60000);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery(validationQuery);
        poolProperties.setValidationInterval(30000L);
        poolProperties.setDefaultAutoCommit(Boolean.valueOf(false));
        if (connectionPropertyElements != null) {
            for (Element element : connectionPropertyElements) {
                String elementKey = element.getKey();
                try {
                    if ("maxIdle".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setMaxIdle(value);
                        continue;
                    }
                    if ("minIdle".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setMinIdle(value);
                        continue;
                    }
                    if ("initialSize".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setInitialSize(value);
                        continue;
                    }
                    if ("maxActive".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setMaxActive(value);
                        continue;
                    }
                    if ("maxWait".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setMaxWait(value);
                        continue;
                    }
                    if ("testOnBorrow".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setTestOnBorrow(value);
                        continue;
                    }
                    if ("validationQuery".equalsIgnoreCase(elementKey)) {
                        poolProperties.setValidationQuery(element.getValue());
                        continue;
                    }
                    if ("validationInterval".equalsIgnoreCase(elementKey)) {
                        long value = Long.parseLong(element.getValue());
                        poolProperties.setValidationInterval(value);
                        continue;
                    }
                    if ("testOnReturn".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setTestOnReturn(value);
                        continue;
                    }
                    if ("testWhileIdle".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setTestWhileIdle(value);
                        continue;
                    }
                    if ("validatorClassName".equalsIgnoreCase(elementKey)) {
                        poolProperties.setValidatorClassName(element.getValue());
                        continue;
                    }
                    if ("timeBetweenEvictionRunsMillis".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setTimeBetweenEvictionRunsMillis(value);
                        continue;
                    }
                    if ("numTestsPerEvictionRun".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setNumTestsPerEvictionRun(value);
                        continue;
                    }
                    if ("minEvictableIdleTimeMillis".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setMinEvictableIdleTimeMillis(value);
                        continue;
                    }
                    if ("accessToUnderlyingConnectionAllowed".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setAccessToUnderlyingConnectionAllowed(value);
                        continue;
                    }
                    if ("removeAbandoned".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setRemoveAbandoned(value);
                        continue;
                    }
                    if ("removeAbandonedTimeout".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setRemoveAbandonedTimeout(value);
                        continue;
                    }
                    if ("logAbandoned".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setLogAbandoned(value);
                        continue;
                    }
                    if ("initSQL".equalsIgnoreCase(elementKey)) {
                        poolProperties.setInitSQL(element.getValue());
                        continue;
                    }
                    if ("jdbcInterceptors".equalsIgnoreCase(elementKey)) {
                        poolProperties.setJdbcInterceptors(element.getValue());
                        continue;
                    }
                    if ("jmxEnabled".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setJmxEnabled(value);
                        continue;
                    }
                    if ("fairQueue".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setFairQueue(value);
                        continue;
                    }
                    if ("abandonWhenPercentageFull".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setAbandonWhenPercentageFull(value);
                        continue;
                    }
                    if ("maxAge".equalsIgnoreCase(elementKey)) {
                        long value = Long.parseLong(element.getValue());
                        poolProperties.setMaxAge(value);
                        continue;
                    }
                    if ("useEquals".equalsIgnoreCase(elementKey)) {
                        boolean value = Boolean.parseBoolean(element.getValue());
                        poolProperties.setUseEquals(value);
                        continue;
                    }
                    if ("suspectTimeout".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setSuspectTimeout(value);
                        continue;
                    }
                    if ("validationQueryTimeout".equalsIgnoreCase(elementKey)) {
                        int value = Integer.parseInt(element.getValue());
                        poolProperties.setValidationQueryTimeout(value);
                        continue;
                    }
                    if (!"alternateUsernameAllowed".equalsIgnoreCase(elementKey)) continue;
                    boolean value = Boolean.parseBoolean(element.getValue());
                    poolProperties.setAlternateUsernameAllowed(value);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid database connection property value: " + element.getValue() + ", ignoring property " + elementKey));
                }
            }
        }
        dataSource.setPoolProperties((PoolConfiguration)poolProperties);
        return dataSource;
    }
}

