/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.cache;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.extension.eventtable.cache.BasicCacheManager;
import org.wso2.siddhi.extension.eventtable.cache.CacheManager;
import org.wso2.siddhi.extension.eventtable.cache.LFUCacheManager;
import org.wso2.siddhi.extension.eventtable.cache.LRUCacheManager;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.TableDefinition;

public class CachingTable {
    private static final Log log = LogFactory.getLog(CachingTable.class);
    private final LinkedList<StreamEvent> list;
    private final ZeroStreamEventConverter eventConverter;
    private final StreamEventPool streamEventPool;
    private String elementId;
    private CacheManager cacheManager;
    public static final long DEFAULT_CACHE_SIZE = 4096L;
    public static final String CACHING_ALGO_LRU = "lru";
    public static final String CACHING_ALGO_LFU = "lfu";

    public CachingTable(String cachingAlgorithm, String cacheSize, ExecutionPlanContext executionPlanContext, TableDefinition tableDefinition) {
        this.elementId = executionPlanContext.getElementIdGenerator().createNewId();
        this.list = new LinkedList();
        long cacheLimit = 4096L;
        if (cacheSize != null) {
            try {
                cacheLimit = Integer.parseInt(cacheSize);
            }
            catch (Exception ex) {
                log.error((Object)"Can't parse the cache size. Creating cache with the default size.");
            }
        }
        this.cacheManager = CACHING_ALGO_LFU.equalsIgnoreCase(cachingAlgorithm) ? new LFUCacheManager(this.list, cacheLimit) : (CACHING_ALGO_LRU.equalsIgnoreCase(cachingAlgorithm) ? new LRUCacheManager(this.list, cacheLimit) : new BasicCacheManager(this.list, cacheLimit));
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        metaStreamEvent.addInputDefinition((AbstractDefinition)tableDefinition);
        for (Attribute attribute : tableDefinition.getAttributeList()) {
            metaStreamEvent.addOutputData(attribute);
        }
        this.streamEventPool = new StreamEventPool(metaStreamEvent, 10);
        this.eventConverter = new ZeroStreamEventConverter();
    }

    public void add(ComplexEvent complexEvent) {
        StreamEvent streamEvent = this.streamEventPool.borrowEvent();
        this.eventConverter.convertComplexEvent(complexEvent, streamEvent);
        this.list.add(streamEvent);
        this.cacheManager.add(streamEvent);
        if (log.isTraceEnabled()) {
            log.trace((Object)("list " + this.elementId + " size " + this.list.size()));
        }
    }

    public void delete(StreamEvent deletingEvent) {
        this.cacheManager.delete(deletingEvent);
        if (log.isTraceEnabled()) {
            log.trace((Object)("list " + this.elementId + " size " + this.list.size()));
        }
    }

    public void update(StreamEvent updatingEvent) {
        StreamEvent streamEvent = this.streamEventPool.borrowEvent();
        this.eventConverter.convertComplexEvent((ComplexEvent)updatingEvent, streamEvent);
        this.cacheManager.update(streamEvent);
        if (log.isTraceEnabled()) {
            log.trace((Object)("list " + this.elementId + " size " + this.list.size()));
        }
    }

    public void overwriteOrAdd(StreamEvent updatingEvent) {
        if (this.cacheManager.isContains(updatingEvent)) {
            StreamEvent streamEvent = this.streamEventPool.borrowEvent();
            this.eventConverter.convertComplexEvent((ComplexEvent)updatingEvent, streamEvent);
            this.cacheManager.update(streamEvent);
        } else {
            StreamEvent streamEvent = this.streamEventPool.borrowEvent();
            this.eventConverter.convertComplexEvent((ComplexEvent)updatingEvent, streamEvent);
            this.list.add(streamEvent);
            this.cacheManager.add(streamEvent);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("list " + this.elementId + " size " + this.list.size()));
        }
    }

    public void contains(StreamEvent matchingEvent) {
        this.cacheManager.read(matchingEvent);
    }

    public LinkedList<StreamEvent> getCacheList() {
        return this.list;
    }

    public void invalidateCache() {
        this.cacheManager.invalidateCache();
    }
}

