/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.util.bloom.CountingBloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.query.api.definition.Attribute;

public class BloomFilterImpl {
    private CountingBloomFilter[] bloomFilters;
    private int bloomFilterSize;
    private int bloomFilterHashFunction;
    private List<Attribute> attributeList;

    public BloomFilterImpl(int bloomFilterSize, int bloomFilterHashFunction, List<Attribute> attributeList) {
        this.bloomFilterSize = bloomFilterSize;
        this.bloomFilterHashFunction = bloomFilterHashFunction;
        this.attributeList = attributeList;
    }

    public void buildBloomFilters(ResultSet results) {
        int i;
        CountingBloomFilter[] bloomFilters = new CountingBloomFilter[this.attributeList.size()];
        for (i = 0; i < bloomFilters.length; ++i) {
            bloomFilters[i] = new CountingBloomFilter(this.bloomFilterSize, this.bloomFilterHashFunction, 1);
        }
        try {
            while (results.next()) {
                block12: for (i = 0; i < bloomFilters.length; ++i) {
                    switch (this.attributeList.get(i).getType()) {
                        case INT: {
                            bloomFilters[i].add(new Key(Integer.toString(results.getInt(i + 1)).getBytes()));
                            continue block12;
                        }
                        case LONG: {
                            bloomFilters[i].add(new Key(Long.toString(results.getLong(i + 1)).getBytes()));
                            continue block12;
                        }
                        case FLOAT: {
                            bloomFilters[i].add(new Key(Float.toString(results.getFloat(i + 1)).getBytes()));
                            continue block12;
                        }
                        case DOUBLE: {
                            bloomFilters[i].add(new Key(Double.toString(results.getDouble(i + 1)).getBytes()));
                            continue block12;
                        }
                        case STRING: {
                            String attributeValue = results.getString(i + 1);
                            if (attributeValue == null) continue block12;
                            bloomFilters[i].add(new Key(attributeValue.getBytes()));
                            continue block12;
                        }
                        case BOOL: {
                            bloomFilters[i].add(new Key(Boolean.toString(results.getBoolean(i + 1)).getBytes()));
                        }
                    }
                }
            }
            results.close();
            this.bloomFilters = bloomFilters;
        }
        catch (SQLException ex) {
            throw new ExecutionPlanRuntimeException("Error while initiating blooms filter with db data, " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void addToBloomFilters(ComplexEvent event) {
        for (int i = 0; i < this.attributeList.size(); ++i) {
            if (event.getOutputData()[i] == null) continue;
            this.bloomFilters[i].add(new Key(event.getOutputData()[i].toString().getBytes()));
        }
    }

    public void addToBloomFilters(Object[] obj) {
        for (int i = 0; i < this.attributeList.size(); ++i) {
            if (obj[i] == null) continue;
            this.bloomFilters[i].add(new Key(obj[i].toString().getBytes()));
        }
    }

    public void removeFromBloomFilters(Object[] obj) {
        for (int i = 0; i < this.attributeList.size(); ++i) {
            if (obj[i] == null) continue;
            this.bloomFilters[i].delete(new Key(obj[i].toString().getBytes()));
        }
    }

    public CountingBloomFilter[] getBloomFilters() {
        return this.bloomFilters;
    }
}

