/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.rdbms;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.exception.CannotLoadConfigurationException;
import org.wso2.siddhi.extension.eventtable.jaxbMappings.Element;
import org.wso2.siddhi.extension.eventtable.jaxbMappings.Mapping;
import org.wso2.siddhi.extension.eventtable.jaxbMappings.Mappings;

public class DBQueryHelper {
    private static Map<String, Map<String, String>> dbTypeMappings;
    private static final Log log;

    private DBQueryHelper() {
    }

    public static void loadConfiguration() throws CannotLoadConfigurationException {
        new DBQueryHelper().populateJaxbMappings();
    }

    private void populateJaxbMappings() throws CannotLoadConfigurationException {
        dbTypeMappings = new HashMap<String, Map<String, String>>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Mappings.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("rdbms-table-config.xml");
            if (inputStream == null) {
                throw new CannotLoadConfigurationException("rdbms-table-config.xml is not found in the classpath");
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(inputStream);
            Mappings mappings = (Mappings)unmarshaller.unmarshal(xmlReader);
            HashMap<String, Mapping> dbMap = new HashMap<String, Mapping>();
            List<Mapping> mappingList = mappings.getMapping();
            for (Mapping mapping : mappingList) {
                dbMap.put(mapping.getDb(), mapping);
            }
            for (Mapping mapping : mappingList) {
                Mapping defaultMapping;
                if (mapping.getDb() != null) {
                    defaultMapping = (Mapping)dbMap.get(null);
                    Mapping specificMapping = (Mapping)dbMap.get(mapping.getDb());
                    List<Element> defaultElementList = defaultMapping.getElements().getElementList();
                    HashMap<String, String> elementMappings = new HashMap<String, String>();
                    for (Element element : defaultElementList) {
                        Element elementDetails = null;
                        if (specificMapping.getElements().getElementList() != null) {
                            elementDetails = specificMapping.getElements().getType(element.getKey());
                        }
                        if (elementDetails == null) {
                            elementDetails = defaultMapping.getElements().getType(element.getKey());
                        }
                        elementMappings.put(elementDetails.getKey(), elementDetails.getValue());
                    }
                    dbTypeMappings.put(mapping.getDb(), elementMappings);
                    continue;
                }
                defaultMapping = (Mapping)dbMap.get(null);
                List<Element> defaultElementList = defaultMapping.getElements().getElementList();
                HashMap<String, String> elementMappings = new HashMap<String, String>();
                for (Element element : defaultElementList) {
                    Element elementDetails = defaultMapping.getElements().getType(element.getKey());
                    elementMappings.put(elementDetails.getKey(), elementDetails.getValue());
                }
                dbTypeMappings.put("default", elementMappings);
            }
        }
        catch (JAXBException e) {
            throw new CannotLoadConfigurationException("Syntax Error.Cannot unmarshal provided File rdbms-table-config.xml" + e.getMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new CannotLoadConfigurationException("Cannot read provided File rdbms-table-config.xml" + e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Map<String, String>> getDbTypeMappings() {
        return dbTypeMappings;
    }

    static {
        log = LogFactory.getLog(DBQueryHelper.class);
    }
}

