/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.geo;

import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.GeocoderRequestBuilder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.GeocoderResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class GeocodeStreamFunctionProcessor
extends StreamFunctionProcessor {
    private static final Log LOGGER = LogFactory.getLog(GeocodeStreamFunctionProcessor.class);
    private final Geocoder geocoder = new Geocoder();
    private boolean debugModeOn;

    protected Object[] process(Object[] data) {
        return this.process(data[0]);
    }

    protected Object[] process(Object data) {
        String formattedAddress;
        double longitude;
        double latitude;
        String location = data.toString();
        GeocoderRequest geocoderRequest = new GeocoderRequestBuilder().setAddress(location).setLanguage("en").getGeocoderRequest();
        try {
            GeocodeResponse geocoderResponse = this.geocoder.geocode(geocoderRequest);
            if (!geocoderResponse.getResults().isEmpty()) {
                latitude = ((GeocoderResult)geocoderResponse.getResults().get(0)).getGeometry().getLocation().getLat().doubleValue();
                longitude = ((GeocoderResult)geocoderResponse.getResults().get(0)).getGeometry().getLocation().getLng().doubleValue();
                formattedAddress = ((GeocoderResult)geocoderResponse.getResults().get(0)).getFormattedAddress();
            } else {
                latitude = -1.0;
                longitude = -1.0;
                formattedAddress = "N/A";
            }
        }
        catch (IOException e) {
            throw new ExecutionPlanRuntimeException("Error in connection to Google Maps API.", (Throwable)e);
        }
        if (this.debugModeOn) {
            LOGGER.debug((Object)("Formatted address: " + formattedAddress + ", Location coordinates: (" + latitude + ", " + longitude + ")"));
        }
        return new Object[]{formattedAddress, latitude, longitude};
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.debugModeOn = LOGGER.isDebugEnabled();
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanCreationException("First parameter should be of type string");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(6);
        attributes.add(new Attribute("formattedAddress", Attribute.Type.STRING));
        attributes.add(new Attribute("latitude", Attribute.Type.DOUBLE));
        attributes.add(new Attribute("longitude", Attribute.Type.DOUBLE));
        return attributes;
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

