/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class CreateFromJSONFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to map:create() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data instanceof String) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(data.toString());
            }
            catch (JSONException e) {
                throw new ExecutionPlanRuntimeException("Cannot create JSON from '" + data.toString() + "' in create from json function", (Throwable)e);
            }
            return this.getMapFromJson(map, jsonObject);
        }
        throw new ExecutionPlanRuntimeException("Data should be a string");
    }

    private Map<Object, Object> getMapFromJson(Map<Object, Object> map, JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Map<Object, Object> value = null;
            try {
                value = jsonObject.get(key);
            }
            catch (JSONException e) {
                throw new ExecutionPlanRuntimeException("JSON '" + jsonObject + "'does not contain key '" + key + "' in create from json function", (Throwable)e);
            }
            if (value instanceof JSONObject) {
                value = this.getMapFromJson(new HashMap<Object, Object>(), (JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

