/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.markov;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.extension.markov.MarkovChainTransitionProbabilitiesCalculator;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class MarkovChainStreamProcessor
extends StreamProcessor
implements SchedulingProcessor {
    private Scheduler scheduler;
    private TrainingMode trainingMode;
    private long durationToKeep;
    private double alertThresholdProbability;
    private long notificationsHoldLimit;
    private String markovMatrixStorageLocation;
    private Boolean trainingOption;
    private ExpressionExecutor trainingOptionExpressionExecutor;
    private MarkovChainTransitionProbabilitiesCalculator markovChainTransitionProbabilitiesCalculator;
    private long lastScheduledTime;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 5 && attributeExpressionExecutors.length != 6) {
            throw new ExecutionPlanValidationException("Markov chain function has to have exactly 5 or 6 parameters, currently " + attributeExpressionExecutors.length + " parameters provided.");
        }
        this.trainingOption = true;
        this.trainingMode = TrainingMode.REAL_TIME;
        if (!(attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("Duration has to be a constant.");
        }
        if (!(attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("Alert threshold probability value has to be a constant.");
        }
        if (!(attributeExpressionExecutors[4] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("Training batch size has to be a constant.");
        }
        Object durationObject = attributeExpressionExecutors[2].execute(null);
        if (durationObject instanceof Integer) {
            this.durationToKeep = ((Integer)durationObject).intValue();
        } else {
            if (!(durationObject instanceof Long)) throw new ExecutionPlanValidationException("Duration should be of type int or long. But found " + attributeExpressionExecutors[2].getReturnType());
            this.durationToKeep = (Long)durationObject;
        }
        Object alertThresholdProbabilityObject = attributeExpressionExecutors[3].execute(null);
        if (!(alertThresholdProbabilityObject instanceof Double)) {
            throw new ExecutionPlanValidationException("Alert threshold probability should be of type double. But found " + attributeExpressionExecutors[3].getReturnType());
        }
        this.alertThresholdProbability = (Double)alertThresholdProbabilityObject;
        Object object = attributeExpressionExecutors[4].execute(null);
        if (object instanceof String) {
            this.markovMatrixStorageLocation = (String)object;
            this.trainingMode = TrainingMode.PREDEFINED_MATRIX;
            File file = new File(this.markovMatrixStorageLocation);
            if (!file.exists()) {
                throw new ExecutionPlanValidationException(this.markovMatrixStorageLocation + " does not exist. Please provide a valid file path.");
            }
            if (!file.isFile()) {
                throw new ExecutionPlanValidationException(this.markovMatrixStorageLocation + " is not a file. Please provide a valid csv file.");
            }
        } else if (object instanceof Integer) {
            this.notificationsHoldLimit = ((Integer)object).intValue();
        } else {
            if (!(object instanceof Long)) throw new ExecutionPlanValidationException("5th parameter should be the Training batch size or Markov matrix storage location. They should be of types int/long or String. But found " + attributeExpressionExecutors[4].getReturnType());
            this.notificationsHoldLimit = (Long)object;
        }
        if (attributeExpressionExecutors.length == 6) {
            if (attributeExpressionExecutors[5] instanceof ConstantExpressionExecutor) {
                Object trainingOptionObject = attributeExpressionExecutors[5].execute(null);
                if (!(trainingOptionObject instanceof Boolean)) throw new ExecutionPlanValidationException("Training option should be of type boolean. But found " + attributeExpressionExecutors[5].getReturnType());
                this.trainingOption = (Boolean)trainingOptionObject;
            } else {
                this.trainingOptionExpressionExecutor = attributeExpressionExecutors[5];
            }
        }
        this.markovChainTransitionProbabilitiesCalculator = this.trainingMode == TrainingMode.PREDEFINED_MATRIX ? new MarkovChainTransitionProbabilitiesCalculator(this.durationToKeep, this.alertThresholdProbability, this.markovMatrixStorageLocation) : new MarkovChainTransitionProbabilitiesCalculator(this.durationToKeep, this.alertThresholdProbability, this.notificationsHoldLimit);
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(3);
        attributeList.add(new Attribute("lastState", Attribute.Type.STRING));
        attributeList.add(new Attribute("transitionProbability", Attribute.Type.DOUBLE));
        attributeList.add(new Attribute("notify", Attribute.Type.BOOL));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        MarkovChainStreamProcessor markovChainStreamProcessor = this;
        synchronized (markovChainStreamProcessor) {
            while (streamEventChunk.hasNext()) {
                String state;
                String id;
                Object[] outputData;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (streamEvent.getType() == ComplexEvent.Type.TIMER) {
                    this.markovChainTransitionProbabilitiesCalculator.removeExpiredEvents(this.executionPlanContext.getTimestampGenerator().currentTime());
                    continue;
                }
                if (streamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.durationToKeep;
                this.scheduler.notifyAt(this.lastScheduledTime);
                if (this.trainingOptionExpressionExecutor != null) {
                    this.trainingOption = (Boolean)this.attributeExpressionExecutors[5].execute((ComplexEvent)streamEvent);
                }
                if ((outputData = this.markovChainTransitionProbabilitiesCalculator.processData(id = (String)this.attributeExpressionExecutors[0].execute((ComplexEvent)streamEvent), state = (String)this.attributeExpressionExecutors[1].execute((ComplexEvent)streamEvent), this.trainingOption)) == null) {
                    streamEventChunk.remove();
                    continue;
                }
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, outputData);
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{this.markovChainTransitionProbabilitiesCalculator, this.trainingOption, this.trainingOptionExpressionExecutor, this.lastScheduledTime};
    }

    public void restoreState(Object[] state) {
        this.markovChainTransitionProbabilitiesCalculator = (MarkovChainTransitionProbabilitiesCalculator)state[0];
        this.trainingOption = (Boolean)state[1];
        this.trainingOptionExpressionExecutor = (ExpressionExecutor)state[2];
        this.lastScheduledTime = (Long)state[3];
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private static enum TrainingMode {
        PREDEFINED_MATRIX,
        REAL_TIME;

    }
}

