/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.markov;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.extension.markov.MarkovMatrix;

public class MarkovChainTransitionProbabilitiesCalculator
implements Serializable {
    private static final long serialVersionUID = -7632888859752532839L;
    private static final Log log = LogFactory.getLog(MarkovChainTransitionProbabilitiesCalculator.class);
    private long durationToKeep;
    private long notificationsHoldLimit;
    private double alertThresholdProbability;
    private int eventCount;
    private Map<String, String> idToLastStates = new HashMap<String, String>();
    private Map<String, Long> idToLastStatesExpiryTime = new LinkedHashMap<String, Long>();
    private MarkovMatrix markovMatrix = new MarkovMatrix();

    public MarkovChainTransitionProbabilitiesCalculator(long durationToKeep, double alertThresholdProbability, long notificationsHoldLimit) {
        this.durationToKeep = durationToKeep;
        this.notificationsHoldLimit = notificationsHoldLimit;
        this.alertThresholdProbability = alertThresholdProbability;
    }

    public MarkovChainTransitionProbabilitiesCalculator(long durationToKeep, double alertThresholdProbability, String markovMatrixStorageLocation) {
        this.durationToKeep = durationToKeep;
        this.alertThresholdProbability = alertThresholdProbability;
        this.populateMarkovMatrix(markovMatrixStorageLocation);
    }

    protected Object[] processData(String id, String currentState, boolean hasTrainingEnabled) {
        ++this.eventCount;
        Object[] markovChainAlert = null;
        String lastState = this.idToLastStates.get(id);
        this.updateStates(id, currentState);
        if ((long)this.eventCount > this.notificationsHoldLimit) {
            markovChainAlert = this.getMarkovChainAlert(lastState, currentState);
        }
        if (hasTrainingEnabled && lastState != null) {
            this.markovMatrix.updateStartStateCount(lastState, 1.0);
            this.markovMatrix.updateTransitionCount(lastState, currentState, 1.0);
        }
        return markovChainAlert;
    }

    private void updateStates(String id, String currentState) {
        this.idToLastStates.put(id, currentState);
        long currentEventTime = System.currentTimeMillis();
        long expiryTime = currentEventTime + this.durationToKeep;
        this.idToLastStatesExpiryTime.put(id, expiryTime);
    }

    private Object[] getMarkovChainAlert(String lastState, String currentState) {
        Double stateTransitionProbability = 0.0;
        boolean notify = false;
        if (lastState != null) {
            String key = this.markovMatrix.getKey(lastState, currentState);
            Double totalCount = this.markovMatrix.getStartStateCount().get(lastState);
            Double transitionCount = this.markovMatrix.getTransitionCount().get(key);
            if (totalCount != null && totalCount != 0.0 && transitionCount != null) {
                stateTransitionProbability = transitionCount / totalCount;
            }
            if (stateTransitionProbability <= this.alertThresholdProbability) {
                notify = true;
            }
        }
        return new Object[]{lastState, stateTransitionProbability, notify};
    }

    protected void removeExpiredEvents(long currentEventTime) {
        for (Map.Entry<String, Long> entry : this.idToLastStatesExpiryTime.entrySet()) {
            if (entry.getValue() > currentEventTime) break;
            this.idToLastStates.remove(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMarkovMatrix(String markovMatrixStorageLocation) {
        File file = new File(markovMatrixStorageLocation);
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        BufferedReader bufferedReader = null;
        String[] statesNames = null;
        HashMap<String, Double> transitionCount = new HashMap<String, Double>();
        HashMap<String, Double> startStateCount = new HashMap<String, Double>();
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            int rowNumber = 0;
            String row = bufferedReader.readLine();
            if (row != null) {
                statesNames = row.split(",");
            }
            while ((row = bufferedReader.readLine()) != null) {
                if (rowNumber >= statesNames.length) {
                    throw new OperationNotSupportedException("Number of rows in the matrix should be equal to number of states. please provide a " + statesNames.length + " x " + statesNames.length + " matrix.");
                }
                String startState = statesNames[rowNumber];
                String[] values = row.split(",");
                double totalCount = 0.0;
                if (values.length != statesNames.length) {
                    throw new OperationNotSupportedException("Number of columns in the matrix should be equal to number of states. please provide a " + statesNames.length + " x " + statesNames.length + " matrix.");
                }
                for (String value : values) {
                    try {
                        totalCount += Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Exception occurred while reading the data file: " + markovMatrixStorageLocation + ". All values in the matrix should be in double."), (Throwable)e);
                    }
                }
                startStateCount.put(startState, totalCount);
                for (int j = 0; j < statesNames.length; ++j) {
                    String endState = statesNames[j];
                    String key = this.markovMatrix.getKey(startState, endState);
                    transitionCount.put(key, Double.parseDouble(values[j]));
                }
                ++rowNumber;
            }
        }
        catch (IOException e) {
            try {
                log.error((Object)("Exception occurred while reading the data file: " + markovMatrixStorageLocation), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closedQuietly(markovMatrixStorageLocation, bufferedReader, bufferedInputStream, fileInputStream);
                throw throwable;
            }
            this.closedQuietly(markovMatrixStorageLocation, bufferedReader, bufferedInputStream, fileInputStream);
        }
        this.closedQuietly(markovMatrixStorageLocation, bufferedReader, bufferedInputStream, fileInputStream);
        this.markovMatrix.setStartStateCount(startStateCount);
        this.markovMatrix.setTransitionCount(transitionCount);
    }

    private void closedQuietly(String closingFile, Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException e) {
                log.error((Object)("Exception occurred while closing the stream related to data file: " + closingFile), (Throwable)e);
            }
        }
    }
}

