/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.markov;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarkovMatrix
implements Serializable {
    private static final Log log = LogFactory.getLog(MarkovMatrix.class);
    private static final long serialVersionUID = -6731569100412292454L;
    private Map<String, Double> transitionCount = new HashMap<String, Double>();
    private Map<String, Double> startStateCount = new HashMap<String, Double>();

    public void updateStartStateCount(String startState, double increment) {
        Double currentCount = this.startStateCount.get(startState);
        this.startStateCount.put(startState, (currentCount == null ? 0.0 : currentCount) + increment);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateStartStateCount: start state: %s count: %s", startState, this.startStateCount.get(startState)));
        }
    }

    public void updateTransitionCount(String startState, String endState, double increment) {
        String key;
        Double currentTransitionCount = this.transitionCount.get(key = this.getKey(startState, endState));
        this.transitionCount.put(key, (currentTransitionCount == null ? 0.0 : currentTransitionCount) + increment);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateTransitionCount: start state: %s end state: %s count: %s total count: %s", startState, endState, increment, this.transitionCount.get(startState)));
        }
    }

    public Map<String, Double> getTransitionCount() {
        return this.transitionCount;
    }

    public void setTransitionCount(Map<String, Double> transitionCount) {
        this.transitionCount = transitionCount;
    }

    public Map<String, Double> getStartStateCount() {
        return this.startStateCount;
    }

    public void setStartStateCount(Map<String, Double> startStateCount) {
        this.startStateCount = startStateCount;
    }

    public String getKey(String startState, String endState) {
        return startState + "%%" + endState;
    }
}

