/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.regex;

import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class MatchesFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;
    private static final Log log = LogFactory.getLog(MatchesFunctionExtension.class);
    private boolean isRegexConstant = false;
    private String regexConstant;
    private Pattern patternConstant;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to regex:matches() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of regex:matches() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of regex:matches() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            this.isRegexConstant = true;
            this.regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            this.patternConstant = Pattern.compile(this.regexConstant);
        }
    }

    protected Object execute(Object[] data) {
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to regex:matches() function. First argument cannot be null");
        }
        if (data[1] == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"Invalid input given to regex:matches() function. Second argument cannot be null, returning false");
            }
            return false;
        }
        String source = (String)data[1];
        if (!this.isRegexConstant) {
            String regex = (String)data[0];
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(source);
            return matcher.matches();
        }
        Matcher matcher = this.patternConstant.matcher(source);
        return matcher.matches();
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, Boolean>("IsRegexConstant", this.isRegexConstant), new AbstractMap.SimpleEntry<String, String>("RegexConstant", this.regexConstant), new AbstractMap.SimpleEntry<String, Pattern>("PatternConstant", this.patternConstant)};
    }

    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.isRegexConstant = (Boolean)stateEntry.getValue();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.regexConstant = (String)stateEntry2.getValue();
        Map.Entry stateEntry3 = (Map.Entry)state[2];
        this.patternConstant = (Pattern)stateEntry3.getValue();
    }
}

