/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.reorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class KSlackExtension
extends StreamProcessor
implements SchedulingProcessor {
    private long k = 0L;
    private long greatestTimestamp = 0L;
    private TreeMap<Long, ArrayList<StreamEvent>> eventTreeMap;
    private TreeMap<Long, ArrayList<StreamEvent>> expiredEventTreeMap;
    private ExpressionExecutor timestampExecutor;
    private long MAX_K = Long.MAX_VALUE;
    private long TIMER_DURATION = -1L;
    private boolean expireFlag = false;
    private long lastSentTimeStamp = -1L;
    private Scheduler scheduler;
    private long lastScheduledTimestamp = -1L;
    private ReentrantLock lock = new ReentrantLock();

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk complexEventChunk = new ComplexEventChunk(false);
        this.lock.lock();
        try {
            while (streamEventChunk.hasNext()) {
                Map.Entry<Long, ArrayList<StreamEvent>> entry;
                Iterator<Map.Entry<Long, ArrayList<StreamEvent>>> entryIterator;
                StreamEvent event = (StreamEvent)streamEventChunk.next();
                if (event.getType() != ComplexEvent.Type.TIMER) {
                    void var9_10;
                    streamEventChunk.remove();
                    long timestamp = (Long)this.timestampExecutor.execute((ComplexEvent)event);
                    if (this.expireFlag && timestamp < this.lastSentTimeStamp) continue;
                    ArrayList<StreamEvent> arrayList = this.eventTreeMap.get(timestamp);
                    if (arrayList == null) {
                        ArrayList arrayList2 = new ArrayList();
                    }
                    var9_10.add(event);
                    this.eventTreeMap.put(timestamp, (ArrayList<StreamEvent>)var9_10);
                    if (timestamp <= this.greatestTimestamp) continue;
                    this.greatestTimestamp = timestamp;
                    long minTimestamp = this.eventTreeMap.firstKey();
                    long timeDifference = this.greatestTimestamp - minTimestamp;
                    if (timeDifference > this.k) {
                        this.k = timeDifference < this.MAX_K ? timeDifference : this.MAX_K;
                    }
                    entryIterator = this.eventTreeMap.entrySet().iterator();
                } else {
                    if (this.expiredEventTreeMap.size() <= 0) continue;
                    TreeMap<Long, ArrayList<StreamEvent>> expiredEventTreeMapSnapShot = this.expiredEventTreeMap;
                    this.expiredEventTreeMap = new TreeMap();
                    this.onTimerEvent(expiredEventTreeMapSnapShot, nextProcessor);
                    this.lastScheduledTimestamp += this.TIMER_DURATION;
                    this.scheduler.notifyAt(this.lastScheduledTimestamp);
                    continue;
                }
                while (entryIterator.hasNext()) {
                    entry = entryIterator.next();
                    ArrayList<StreamEvent> list = this.expiredEventTreeMap.get(entry.getKey());
                    if (list != null) {
                        list.addAll((Collection<StreamEvent>)entry.getValue());
                        continue;
                    }
                    this.expiredEventTreeMap.put(entry.getKey(), entry.getValue());
                }
                this.eventTreeMap = new TreeMap();
                entryIterator = this.expiredEventTreeMap.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    entry = entryIterator.next();
                    if (entry.getKey() + this.k > this.greatestTimestamp) continue;
                    entryIterator.remove();
                    ArrayList<StreamEvent> timeEventList = entry.getValue();
                    this.lastSentTimeStamp = entry.getKey();
                    for (StreamEvent aTimeEventList : timeEventList) {
                        complexEventChunk.add((ComplexEvent)aTimeEventList);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ec) {
            throw new ExecutionPlanCreationException("The very first parameter must be an Integer with a valid  field index (0 to (fieldsLength-1)).");
        }
        this.lock.unlock();
        nextProcessor.process(complexEventChunk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.attributeExpressionLength > 4) {
            throw new ExecutionPlanCreationException("Maximum four input parameters can be specified for KSlack.  Timestamp field (long), k-slack buffer expiration time-out window (long), Max_K size (long), and boolean  flag to indicate whether the late events should get discarded. But found " + this.attributeExpressionLength + " attributes.");
        }
        if (attributeExpressionExecutors.length == 1) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanCreationException("Invalid parameter type found for the first argument of reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[0].getReturnType());
            this.timestampExecutor = attributeExpressionExecutors[0];
            attributes.add(new Attribute("beta0", Attribute.Type.LONG));
        } else if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                throw new ExecutionPlanCreationException("Invalid parameter type found for the first argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[0].getReturnType());
            }
            this.timestampExecutor = attributeExpressionExecutors[0];
            attributes.add(new Attribute("beta0", Attribute.Type.LONG));
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanCreationException("Invalid parameter type found for the second argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[1].getReturnType());
            this.TIMER_DURATION = (Long)attributeExpressionExecutors[1].execute(null);
            attributes.add(new Attribute("beta1", Attribute.Type.LONG));
        } else if (attributeExpressionExecutors.length == 3) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                throw new ExecutionPlanCreationException("Invalid parameter type found for the first argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[0].getReturnType());
            }
            this.timestampExecutor = attributeExpressionExecutors[0];
            attributes.add(new Attribute("beta0", Attribute.Type.LONG));
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) {
                throw new ExecutionPlanCreationException("Invalid parameter type found for the second argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[1].getReturnType());
            }
            this.TIMER_DURATION = (Long)attributeExpressionExecutors[1].execute(null);
            attributes.add(new Attribute("beta1", Attribute.Type.LONG));
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanCreationException("Invalid parameter type found for the third argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[2].getReturnType());
            this.MAX_K = (Long)attributeExpressionExecutors[2].execute(null);
            attributes.add(new Attribute("beta2", Attribute.Type.LONG));
        } else if (attributeExpressionExecutors.length == 4) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                throw new ExecutionPlanCreationException("Invalid parameter type found for the first argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[0].getReturnType());
            }
            this.timestampExecutor = attributeExpressionExecutors[0];
            attributes.add(new Attribute("beta0", Attribute.Type.LONG));
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) {
                throw new ExecutionPlanCreationException("Invalid parameter type found for the second argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[1].getReturnType());
            }
            this.TIMER_DURATION = (Long)attributeExpressionExecutors[1].execute(null);
            attributes.add(new Attribute("beta1", Attribute.Type.LONG));
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.LONG) {
                throw new ExecutionPlanCreationException("Invalid parameter type found for the third argument of  reorder:kslack() function. Required LONG, but found " + attributeExpressionExecutors[2].getReturnType());
            }
            this.MAX_K = (Long)attributeExpressionExecutors[2].execute(null);
            attributes.add(new Attribute("beta2", Attribute.Type.LONG));
            if (attributeExpressionExecutors[3].getReturnType() != Attribute.Type.BOOL) throw new ExecutionPlanCreationException("Invalid parameter type found for the fourth argument of  reorder:kslack() function. Required BOOL, but found " + attributeExpressionExecutors[3].getReturnType());
            this.expireFlag = (Boolean)attributeExpressionExecutors[3].execute(null);
            attributes.add(new Attribute("beta3", Attribute.Type.BOOL));
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new ExecutionPlanCreationException("Return type expected by KSlack is LONG but found " + attributeExpressionExecutors[0].getReturnType());
        }
        this.timestampExecutor = attributeExpressionExecutors[0];
        this.eventTreeMap = new TreeMap();
        this.expiredEventTreeMap = new TreeMap();
        if (this.TIMER_DURATION == -1L || this.scheduler == null) return attributes;
        this.lastScheduledTimestamp = executionPlanContext.getTimestampGenerator().currentTime() + this.TIMER_DURATION;
        this.scheduler.notifyAt(this.lastScheduledTimestamp);
        return attributes;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        if (this.lastScheduledTimestamp < 0L) {
            this.lastScheduledTimestamp = this.executionPlanContext.getTimestampGenerator().currentTime() + this.TIMER_DURATION;
            scheduler.notifyAt(this.lastScheduledTimestamp);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private void onTimerEvent(TreeMap<Long, ArrayList<StreamEvent>> treeMap, Processor nextProcessor) {
        Iterator<Map.Entry<Long, ArrayList<StreamEvent>>> entryIterator = treeMap.entrySet().iterator();
        ComplexEventChunk complexEventChunk = new ComplexEventChunk(false);
        while (entryIterator.hasNext()) {
            ArrayList<StreamEvent> timeEventList = entryIterator.next().getValue();
            for (StreamEvent aTimeEventList : timeEventList) {
                complexEventChunk.add((ComplexEvent)aTimeEventList);
            }
        }
        nextProcessor.process(complexEventChunk);
    }
}

