/*
 * Copyright (c) 2015, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.wso2.siddhi.extension.time.util;

/**
 * This class contains the constants related to Time Extension
 */
public final class TimeExtensionConstants {

    private TimeExtensionConstants() {
    }

    public static final String EXTENSION_TIME_UNIT_SECOND = "SECOND";
    public static final String EXTENSION_TIME_UNIT_MINUTE = "MINUTE";
    public static final String EXTENSION_TIME_UNIT_HOUR = "HOUR";
    public static final String EXTENSION_TIME_UNIT_DAY = "DAY";
    public static final String EXTENSION_TIME_UNIT_WEEK = "WEEK";
    public static final String EXTENSION_TIME_UNIT_MONTH = "MONTH";
    public static final String EXTENSION_TIME_UNIT_QUARTER = "QUARTER";
    public static final String EXTENSION_TIME_UNIT_YEAR = "YEAR";
    public static final String EXTENSION_TIME_DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String EXTENSION_TIME_DATE_FORMAT = "yyyy-MM-dd";
    public static final String EXTENSION_TIME_UTC_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String EXTENSION_TIME_CURRENT_TIME_FORMAT = "HH:mm:ss";
    public static final String EXTENSION_TIME_CURRENT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";



}
