/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class DateDifferenceFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.LONG;
    private static final Log log = LogFactory.getLog(DateDifferenceFunctionExtension.class);
    private boolean useDefaultDateFormat = false;
    private String firstDateFormat = null;
    private String secondDateFormat = null;
    private Calendar firstCalInstance = Calendar.getInstance();
    private Calendar secondCalInstance = Calendar.getInstance();

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors.length == 3 || attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors.length == 2) {
            this.useDefaultDateFormat = true;
            this.firstDateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
            this.secondDateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if (attributeExpressionExecutors.length == 4) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[2].getReturnType().toString());
            }
            if (attributeExpressionExecutors[3].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the fourth argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[3].getReturnType().toString());
            }
        } else if (attributeExpressionExecutors.length == 2) {
            if (this.useDefaultDateFormat) {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateDiff(timestampInMilliseconds1,timestampInMilliseconds2) function, required " + Attribute.Type.LONG + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateDiff(timestampInMilliseconds1,timestampInMilliseconds2) function, required " + Attribute.Type.LONG + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
            }
        } else if (attributeExpressionExecutors.length == 3 && this.useDefaultDateFormat) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[2].getReturnType().toString());
            }
        } else {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:dateDiff() function, required 2 or 4, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        String firstDate = null;
        if (data.length == 4 || this.useDefaultDateFormat) {
            FastDateFormat userSpecifiedSecondFormat;
            String secondDate;
            try {
                if (data[0] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function. First argument cannot be null");
                }
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function. Second argument cannot be null");
                }
                if (!this.useDefaultDateFormat) {
                    if (data[2] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function. Third argument cannot be null");
                    }
                    if (data[3] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to time:dateDiff(dateValue1,dateValue2,dateFormat1,dateFormat2) function. Fourth argument cannot be null");
                    }
                    this.firstDateFormat = (String)data[2];
                    this.secondDateFormat = (String)data[3];
                } else if (data.length != 2) {
                    this.firstDateFormat = (String)data[2];
                }
                firstDate = (String)data[0];
                secondDate = (String)data[1];
                FastDateFormat userSpecifiedFirstFormat = FastDateFormat.getInstance((String)this.firstDateFormat);
                userSpecifiedSecondFormat = FastDateFormat.getInstance((String)this.secondDateFormat);
                Date userSpecifiedFirstDate = userSpecifiedFirstFormat.parse(firstDate);
                this.firstCalInstance.setTime(userSpecifiedFirstDate);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.firstDateFormat + " does not match with the timestamp " + firstDate + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            try {
                Date userSpecifiedSecondDate = userSpecifiedSecondFormat.parse(secondDate);
                this.secondCalInstance.setTime(userSpecifiedSecondDate);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.secondDateFormat + " does not match with the timestamp " + secondDate + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        if (data.length == 2) {
            if (data[0] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateDiff(timestampInMilliseconds1,timestampInMilliseconds2) function. First argument cannot be null");
            }
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateDiff(timestampInMilliseconds1,timestampInMilliseconds2) function. Second argument cannot be null");
            }
            try {
                long firstDateInMills = (Long)data[0];
                long secondDateInMills = (Long)data[1];
                this.firstCalInstance.setTimeInMillis(firstDateInMills);
                this.secondCalInstance.setTimeInMillis(secondDateInMills);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        } else {
            throw new ExecutionPlanRuntimeException("Invalid set of arguments given to time:dateDiff() function.Arguments should be either 2 or 4. ");
        }
        long dateDifference = this.firstCalInstance.getTimeInMillis() - this.secondCalInstance.getTimeInMillis();
        return TimeUnit.DAYS.convert(dateDifference, TimeUnit.MILLISECONDS);
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

