/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.extrema;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.extension.timeseries.extrema.util.ExtremaCalculator;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class KernelMinMaxStreamProcessor
extends StreamProcessor {
    ExtremaType extremaType;
    int[] variablePosition;
    double bw = 0.0;
    int windowSize = 0;
    LinkedList<StreamEvent> eventStack = null;
    Queue<Double> valueStack = null;
    Queue<StreamEvent> uniqueQueue = null;
    private int minEventPos;
    private int maxEventPos;
    ExtremaCalculator extremaCalculator = null;

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 4) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to KernelMinMaxStreamProcessor, required 4, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.DOUBLE && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.INT && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.FLOAT && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 1st argument of KernelMinMaxStreamProcessor, required " + Attribute.Type.DOUBLE + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        try {
            this.bw = Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
        }
        catch (NumberFormatException e) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 2nd argument of KernelMinMaxStreamProcessor required " + Attribute.Type.DOUBLE + " constant, but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (!(attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor) || attributeExpressionExecutors[2].getReturnType() != Attribute.Type.INT) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 3rd argument of KernelMinMaxStreamProcessor, required " + Attribute.Type.INT + " constant, but found " + attributeExpressionExecutors[2].getReturnType().toString());
        }
        if (!(attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor) || attributeExpressionExecutors[3].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 4th argument of KernelMinMaxStreamProcessor, required " + Attribute.Type.STRING + " constant, but found " + attributeExpressionExecutors[2].getReturnType().toString());
        }
        this.variablePosition = ((VariableExpressionExecutor)attributeExpressionExecutors[0]).getPosition();
        this.windowSize = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue()));
        String extremeType = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue();
        this.extremaType = "min".equalsIgnoreCase(extremeType) ? ExtremaType.MIN : ("max".equalsIgnoreCase(extremeType) ? ExtremaType.MAX : ExtremaType.MINMAX);
        this.extremaCalculator = new ExtremaCalculator();
        this.eventStack = new LinkedList();
        this.valueStack = new LinkedList<Double>();
        this.uniqueQueue = new LinkedList<StreamEvent>();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("extremaType", Attribute.Type.STRING));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk returnEventChunk = new ComplexEventChunk(false);
        KernelMinMaxStreamProcessor kernelMinMaxStreamProcessor = this;
        synchronized (kernelMinMaxStreamProcessor) {
            while (streamEventChunk.hasNext()) {
                StreamEvent event = (StreamEvent)streamEventChunk.next();
                streamEventChunk.remove();
                Double eventKey = (Double)event.getAttribute(this.variablePosition);
                this.eventStack.add(event);
                this.valueStack.add(eventKey);
                if (this.eventStack.size() <= this.windowSize) continue;
                Queue<Double> smoothedValues = this.extremaCalculator.smooth(this.valueStack, this.bw);
                switch (this.extremaType) {
                    case MINMAX: {
                        StreamEvent maximumEvent = this.getMaxEvent(smoothedValues);
                        StreamEvent minimumEvent = this.getMinEvent(smoothedValues);
                        if (maximumEvent != null && minimumEvent != null) {
                            if (this.maxEventPos > this.minEventPos) {
                                returnEventChunk.add((ComplexEvent)minimumEvent);
                                returnEventChunk.add((ComplexEvent)maximumEvent);
                                break;
                            }
                            returnEventChunk.add((ComplexEvent)maximumEvent);
                            returnEventChunk.add((ComplexEvent)minimumEvent);
                            break;
                        }
                        if (maximumEvent != null) {
                            returnEventChunk.add((ComplexEvent)maximumEvent);
                            break;
                        }
                        if (minimumEvent == null) break;
                        returnEventChunk.add((ComplexEvent)minimumEvent);
                        break;
                    }
                    case MIN: {
                        StreamEvent minimumEvent = this.getMinEvent(smoothedValues);
                        if (minimumEvent == null) break;
                        returnEventChunk.add((ComplexEvent)minimumEvent);
                        break;
                    }
                    case MAX: {
                        StreamEvent maximumEvent = this.getMaxEvent(smoothedValues);
                        if (maximumEvent == null) break;
                        returnEventChunk.add((ComplexEvent)maximumEvent);
                    }
                }
                this.eventStack.remove();
                this.valueStack.remove();
            }
        }
        if (returnEventChunk.getFirst() != null) {
            nextProcessor.process(returnEventChunk);
        }
    }

    private StreamEvent getMaxEvent(Queue<Double> smoothedValues) {
        Integer maxEventPosition;
        StreamEvent returnMaximumEvent;
        Integer maxPosition = this.extremaCalculator.findMax(smoothedValues, 1);
        if (maxPosition != null && (returnMaximumEvent = this.getExtremaEvent(maxPosition, maxEventPosition = this.extremaCalculator.findMax(this.valueStack, this.windowSize / 5, this.windowSize / 3))) != null) {
            this.maxEventPos = maxEventPosition;
            this.complexEventPopulater.populateComplexEvent((ComplexEvent)returnMaximumEvent, new Object[]{"max"});
            return returnMaximumEvent;
        }
        return null;
    }

    private StreamEvent getMinEvent(Queue<Double> smoothedValues) {
        Integer minEventPosition;
        StreamEvent returnMinimumEvent;
        Integer minPosition = this.extremaCalculator.findMin(smoothedValues, 1);
        if (minPosition != null && (returnMinimumEvent = this.getExtremaEvent(minPosition, minEventPosition = this.extremaCalculator.findMin(this.valueStack, this.windowSize / 5, this.windowSize / 3))) != null) {
            this.minEventPos = minEventPosition;
            this.complexEventPopulater.populateComplexEvent((ComplexEvent)returnMinimumEvent, new Object[]{"min"});
            return returnMinimumEvent;
        }
        return null;
    }

    private StreamEvent getExtremaEvent(Integer smoothenedPosition, Integer eventPosition) {
        StreamEvent extremaEvent;
        if (eventPosition != null && eventPosition - smoothenedPosition <= this.windowSize / 5 && smoothenedPosition - eventPosition <= this.windowSize / 2 && !this.uniqueQueue.contains(extremaEvent = this.eventStack.get(eventPosition))) {
            if (this.uniqueQueue.size() > 5) {
                this.uniqueQueue.remove();
            }
            this.uniqueQueue.add(extremaEvent);
            this.eventStack.remove();
            this.valueStack.remove();
            return this.streamEventCloner.copyStreamEvent(extremaEvent);
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, LinkedList<StreamEvent>>("EventStack", this.eventStack), new AbstractMap.SimpleEntry<String, Queue<Double>>("ValueStack", this.valueStack), new AbstractMap.SimpleEntry<String, Queue<StreamEvent>>("UniqueQueue", this.uniqueQueue)};
    }

    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.eventStack = (LinkedList)stateEntry.getValue();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.valueStack = (Queue)stateEntry2.getValue();
        Map.Entry stateEntry3 = (Map.Entry)state[2];
        this.uniqueQueue = (Queue)stateEntry3.getValue();
    }

    public static enum ExtremaType {
        MIN,
        MAX,
        MINMAX;

    }
}

