/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.linreg;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.distribution.TDistribution;
import org.wso2.siddhi.extension.timeseries.linreg.LengthTimeRegressionCalculator;

public class LengthTimeSimpleLinearRegressionCalculator
extends LengthTimeRegressionCalculator {
    private List<Double> xValueList = new LinkedList<Double>();
    private List<Double> yValueList = new LinkedList<Double>();
    private double sumX = 0.0;
    private double sumY = 0.0;
    private double sumXsquared = 0.0;

    public LengthTimeSimpleLinearRegressionCalculator(int paramCount, long timeWindow, int lengthWindow, int calcInt, double ci) {
        super(paramCount, timeWindow, lengthWindow, calcInt, ci);
    }

    @Override
    protected void addEvent(Object[] data, long expiryTime) {
        this.currentEventTime = expiryTime - this.duration;
        ++this.incCounter;
        ++this.eventCount;
        double yValue = ((Number)data[0]).doubleValue();
        this.yValueList.add(yValue);
        double xValue = ((Number)data[1]).doubleValue();
        this.xValueList.add(xValue);
        this.expiryTimeList.add(expiryTime);
        this.sumX += xValue;
        this.sumXsquared += xValue * xValue;
        this.sumY += yValue;
    }

    @Override
    protected void removeExpiredEvents() {
        double xValueRemoved;
        while ((Long)this.expiryTimeList.peek() <= this.currentEventTime) {
            xValueRemoved = this.xValueList.remove(0);
            this.sumX -= xValueRemoved;
            this.sumXsquared -= xValueRemoved * xValueRemoved;
            this.sumY -= this.yValueList.remove(0).doubleValue();
            this.expiryTimeList.poll();
            --this.eventCount;
        }
        if (this.eventCount > this.batchSize) {
            xValueRemoved = this.xValueList.remove(0);
            this.sumX -= xValueRemoved;
            this.sumXsquared -= xValueRemoved * xValueRemoved;
            this.sumY -= this.yValueList.remove(0).doubleValue();
            this.expiryTimeList.poll();
            --this.eventCount;
        }
    }

    @Override
    protected Object[] processData() {
        Object[] regResult;
        try {
            int i;
            Double[] xArray = this.xValueList.toArray(new Double[this.eventCount]);
            Double[] yArray = this.yValueList.toArray(new Double[this.eventCount]);
            double varianceX = 0.0;
            double varianceY = 0.0;
            double covarXY = 0.0;
            double resss = 0.0;
            int df = this.eventCount - 2;
            TDistribution t = new TDistribution((double)df);
            double meanX = this.sumX / (double)this.eventCount;
            double meanY = this.sumY / (double)this.eventCount;
            for (i = 0; i < this.eventCount; ++i) {
                varianceX += (xArray[i] - meanX) * (xArray[i] - meanX);
                covarXY += (xArray[i] - meanX) * (yArray[i] - meanY);
            }
            double beta1 = covarXY / varianceX;
            double beta0 = meanY - beta1 * meanX;
            for (i = 0; i < this.eventCount; ++i) {
                double fit = beta1 * xArray[i] + beta0;
                resss += (fit - yArray[i]) * (fit - yArray[i]);
            }
            double stderr = Math.sqrt(resss / (double)df);
            double beta1err = stderr / Math.sqrt(varianceX);
            double beta0err = stderr * Math.sqrt(this.sumXsquared / ((double)this.eventCount * varianceX));
            double tBeta0 = beta0 / beta0err;
            double tBeta1 = beta1 / beta1err;
            double pValue = 2.0 * (1.0 - t.cumulativeProbability(Math.abs(tBeta0)));
            if (pValue > 1.0 - this.confidenceInterval) {
                beta0 = 0.0;
            }
            if ((pValue = 2.0 * (1.0 - t.cumulativeProbability(Math.abs(tBeta1)))) > 1.0 - this.confidenceInterval) {
                beta1 = 0.0;
            }
            regResult = new Object[]{stderr, beta0, beta1};
        }
        catch (Exception e) {
            regResult = new Object[]{0.0, 0.0, 0.0};
        }
        return regResult;
    }
}

