/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.linreg;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.distribution.TDistribution;
import org.wso2.siddhi.extension.timeseries.linreg.RegressionCalculator;

public class SimpleLinearRegressionCalculator
extends RegressionCalculator {
    private List<Double> xValueList = new LinkedList<Double>();
    private List<Double> yValueList = new LinkedList<Double>();
    private double sumX = 0.0;
    private double sumY = 0.0;
    private double sumXsquared = 0.0;
    private double xValue;
    private double yValue;

    public SimpleLinearRegressionCalculator(int paramCount, int calcInt, int limit, double ci) {
        super(paramCount, calcInt, limit, ci);
    }

    @Override
    protected void addEvent(Object[] data) {
        ++this.eventCount;
        ++this.incCounter;
        this.yValue = ((Number)data[0]).doubleValue();
        this.yValueList.add(this.yValue);
        this.xValue = ((Number)data[1]).doubleValue();
        this.xValueList.add(this.xValue);
        this.sumX += this.xValue;
        this.sumXsquared += this.xValue * this.xValue;
        this.sumY += this.yValue;
    }

    @Override
    protected void removeEvent() {
        double xValue = this.xValueList.remove(0);
        this.sumX -= xValue;
        this.sumXsquared -= xValue * xValue;
        this.sumY -= this.yValueList.remove(0).doubleValue();
    }

    @Override
    protected Object[] processData() {
        Object[] regResult;
        try {
            int i;
            Double[] xArray = this.xValueList.toArray(new Double[this.eventCount]);
            Double[] yArray = this.yValueList.toArray(new Double[this.eventCount]);
            double varianceX = 0.0;
            double varianceY = 0.0;
            double covarXY = 0.0;
            double resss = 0.0;
            int df = this.eventCount - 2;
            TDistribution t = new TDistribution((double)df);
            double meanX = this.sumX / (double)this.eventCount;
            double meanY = this.sumY / (double)this.eventCount;
            for (i = 0; i < this.eventCount; ++i) {
                varianceX += (xArray[i] - meanX) * (xArray[i] - meanX);
                covarXY += (xArray[i] - meanX) * (yArray[i] - meanY);
            }
            double beta1 = covarXY / varianceX;
            double beta0 = meanY - beta1 * meanX;
            for (i = 0; i < this.eventCount; ++i) {
                double fit = beta1 * xArray[i] + beta0;
                resss += (fit - yArray[i]) * (fit - yArray[i]);
            }
            double stderr = Math.sqrt(resss / (double)df);
            double beta1err = stderr / Math.sqrt(varianceX);
            double beta0err = stderr * Math.sqrt(this.sumXsquared / ((double)this.eventCount * varianceX));
            double t_beta0 = beta0 / beta0err;
            double t_beta1 = beta1 / beta1err;
            double pValue = 2.0 * (1.0 - t.cumulativeProbability(Math.abs(t_beta0)));
            if (pValue > 1.0 - this.confidenceInterval) {
                beta0 = 0.0;
            }
            if ((pValue = 2.0 * (1.0 - t.cumulativeProbability(Math.abs(t_beta1)))) > 1.0 - this.confidenceInterval) {
                beta1 = 0.0;
            }
            regResult = new Object[]{stderr, beta0, beta1};
        }
        catch (Exception e) {
            regResult = new Object[]{0.0, 0.0, 0.0};
        }
        return regResult;
    }
}

