/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.extension.timeseries.linreg.MultipleLinearRegressionCalculator;
import org.wso2.siddhi.extension.timeseries.linreg.RegressionCalculator;
import org.wso2.siddhi.extension.timeseries.linreg.SimpleLinearRegressionCalculator;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class LinearRegressionStreamProcessor
extends StreamProcessor {
    private int paramCount = 0;
    private int calcInterval = 1;
    private int batchSize = 1000000000;
    private double ci = 0.95;
    private final int SIMPLE_LINREG_INPUT_PARAM_COUNT = 2;
    private RegressionCalculator regressionCalculator = null;
    private int paramPosition = 0;

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.paramCount = this.attributeExpressionLength;
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            this.paramCount -= 3;
            this.paramPosition = 3;
            try {
                this.calcInterval = (Integer)attributeExpressionExecutors[0].execute(null);
                this.batchSize = (Integer)attributeExpressionExecutors[1].execute(null);
            }
            catch (ClassCastException c) {
                throw new ExecutionPlanCreationException("Calculation interval, batch size and range should be of type int");
            }
            try {
                this.ci = (Double)attributeExpressionExecutors[2].execute(null);
            }
            catch (ClassCastException c) {
                throw new ExecutionPlanCreationException("Confidence interval should be of type double");
            }
            if (!(0.0 <= this.ci) || !(this.ci <= 1.0)) {
                throw new ExecutionPlanCreationException("Confidence interval should be a value between 0 and 1");
            }
        }
        this.regressionCalculator = this.paramCount > 2 ? new MultipleLinearRegressionCalculator(this.paramCount, this.calcInterval, this.batchSize, this.ci) : new SimpleLinearRegressionCalculator(this.paramCount, this.calcInterval, this.batchSize, this.ci);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.paramCount);
        attributes.add(new Attribute("stderr", Attribute.Type.DOUBLE));
        for (int itr = 0; itr < this.paramCount; ++itr) {
            String betaVal = "beta" + itr;
            attributes.add(new Attribute(betaVal, Attribute.Type.DOUBLE));
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        LinearRegressionStreamProcessor linearRegressionStreamProcessor = this;
        synchronized (linearRegressionStreamProcessor) {
            while (streamEventChunk.hasNext()) {
                ComplexEvent complexEvent = streamEventChunk.next();
                Object[] inputData = new Object[this.attributeExpressionLength - this.paramPosition];
                for (int i = this.paramPosition; i < this.attributeExpressionLength; ++i) {
                    inputData[i - this.paramPosition] = this.attributeExpressionExecutors[i].execute(complexEvent);
                }
                Object[] outputData = this.regressionCalculator.calculateLinearRegression(inputData);
                if (outputData == null) {
                    streamEventChunk.remove();
                    continue;
                }
                complexEventPopulater.populateComplexEvent(complexEvent, outputData);
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

