/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.extrema.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ExtremaCalculator {
    private double bw = 0.0;
    private double[] kernelValues = null;
    private double Q = 1.0E-6;
    private double R = 1.0E-4;
    private double P = 1.0;
    private double X = 0.0;
    private double K;

    public ExtremaCalculator(double Q, double R) {
        this.Q = Q;
        this.R = R;
    }

    public ExtremaCalculator() {
    }

    private Double gaussianKernel(int x) {
        Double kernVal = Math.pow(Math.E, (double)(-x * x) / (2.0 * this.bw * this.bw)) / (this.bw * Math.sqrt(Math.PI * 2));
        return kernVal;
    }

    public Queue<Double> smooth(Queue<Double> input, double bw) {
        this.bw = bw;
        if (this.kernelValues == null) {
            this.kernelValues = new double[input.size() + 2];
            for (int i = 0; i <= input.size(); ++i) {
                this.kernelValues[i] = this.gaussianKernel(i);
            }
        }
        int size = input.size();
        LinkedList<Double> output = new LinkedList<Double>();
        for (int i = 0; i < size; ++i) {
            Double kernUp = 0.0;
            Double kernDown = 0.0;
            Iterator itr = input.iterator();
            int j = 0;
            while (itr.hasNext()) {
                Double price = (Double)itr.next();
                Double kern = i - j >= 0 ? Double.valueOf(this.kernelValues[i - j]) : Double.valueOf(this.kernelValues[j - i]);
                kernUp = kernUp + kern * price;
                kernDown = kernDown + kern;
                ++j;
            }
            output.add(kernUp / kernDown);
        }
        return output;
    }

    public Integer findMax(Queue<Double> input, int bandwidth) {
        int size = input.size();
        Object[] inputArray = input.toArray();
        for (int i = size - bandwidth - 1; i >= bandwidth; --i) {
            Double max = Double.MIN_VALUE;
            for (int j = i - bandwidth; j <= i + bandwidth; ++j) {
                if (!((Double)inputArray[j] > max)) continue;
                max = (Double)inputArray[j];
            }
            if (!inputArray[i].equals(max)) continue;
            return i;
        }
        return null;
    }

    public Integer findMin(Queue<Double> input, int bandwidth) {
        int size = input.size();
        Object[] inputArray = input.toArray();
        for (int i = size - bandwidth - 1; i >= bandwidth; --i) {
            Double min = Double.MAX_VALUE;
            for (int j = i - bandwidth; j <= i + bandwidth; ++j) {
                if (!((Double)inputArray[j] < min)) continue;
                min = (Double)inputArray[j];
            }
            if (!inputArray[i].equals(min)) continue;
            return i;
        }
        return null;
    }

    public Integer findMax(Queue<Double> input, int leftBandwidth, int rightBandwidth) {
        int size = input.size();
        Object[] inputArray = input.toArray();
        for (int i = size - rightBandwidth - 1; i >= leftBandwidth; --i) {
            Double max = Double.MIN_VALUE;
            for (int j = i - leftBandwidth; j <= i + rightBandwidth; ++j) {
                if (!((Double)inputArray[j] > max)) continue;
                max = (Double)inputArray[j];
            }
            if (!inputArray[i].equals(max)) continue;
            return i;
        }
        return null;
    }

    public Integer findMin(Queue<Double> input, int leftBandwidth, int rightBandwidth) {
        int size = input.size();
        Object[] inputArray = input.toArray();
        for (int i = size - rightBandwidth - 1; i >= leftBandwidth; --i) {
            Double min = Double.MAX_VALUE;
            for (int j = i - leftBandwidth; j <= i + rightBandwidth; ++j) {
                if (!((Double)inputArray[j] < min)) continue;
                min = (Double)inputArray[j];
            }
            if (!inputArray[i].equals(min)) continue;
            return i;
        }
        return null;
    }

    private void measurementUpdate() {
        this.K = (this.P + this.Q) / (this.P + this.Q + this.R);
        this.P = this.R * (this.P + this.Q) / (this.R + this.P + this.Q);
    }

    public double update(double measurement) {
        double result;
        this.measurementUpdate();
        this.X = result = this.X + (measurement - this.X) * this.K;
        return result;
    }

    public Queue<Double> kalmanFilter(Queue<Double> input) {
        LinkedList<Double> dataOutput = new LinkedList<Double>();
        Iterator iterator = input.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            dataOutput.add(this.update(d));
        }
        return dataOutput;
    }
}

