/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.linreg;

import java.util.PriorityQueue;
import java.util.Queue;

public abstract class LengthTimeRegressionCalculator {
    protected long duration;
    protected int batchSize;
    protected int calcInterval = 1;
    protected double confidenceInterval = 0.95;
    protected int eventCount = 0;
    protected int xParameterCount = 0;
    protected int incCounter = 0;
    protected long currentEventTime;
    protected Queue<Long> expiryTimeList = new PriorityQueue<Long>();

    public LengthTimeRegressionCalculator(int paramCount, long timeWindow, int lengthWindow, int calcInt, double ci) {
        this.duration = timeWindow;
        this.batchSize = lengthWindow;
        this.calcInterval = calcInt;
        this.confidenceInterval = ci;
        this.xParameterCount = paramCount - 1;
    }

    protected abstract void addEvent(Object[] var1, long var2);

    protected abstract void removeExpiredEvents();

    protected abstract Object[] processData();

    public Object[] calculateLinearRegression(Object[] data, long expiryTime) {
        this.addEvent(data, expiryTime);
        this.removeExpiredEvents();
        if (this.incCounter % this.calcInterval != 0) {
            return null;
        }
        return this.processData();
    }
}

