/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.extension.timeseries.linreg.LengthTimeRegressionCalculator;
import org.wso2.siddhi.extension.timeseries.linreg.LengthTimeSimpleLinearRegressionCalculator;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class LengthTimeLinearRegressionForecastStreamProcessor
extends StreamProcessor {
    private int paramCount;
    private long duration;
    private int calcInterval = 1;
    private double ci = 0.95;
    private LengthTimeRegressionCalculator regressionCalculator = null;
    private int yParameterPosition;
    private static final int SIMPLE_LINREG_INPUT_PARAM_COUNT = 2;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.paramCount = this.attributeExpressionLength - 3;
        this.yParameterPosition = 3;
        if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanCreationException("Time duration parameter must be a constant");
        if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
            this.duration = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
        } else {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanCreationException("Time duration parameter should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
            this.duration = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanCreationException("Size parameter must be a constant");
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
            throw new ExecutionPlanCreationException("Size parameter should be int, but found " + attributeExpressionExecutors[1].getReturnType());
        }
        int batchSize = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
        if (attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor) {
            this.paramCount -= 2;
            this.yParameterPosition = 5;
            if (attributeExpressionExecutors[3].getReturnType() != Attribute.Type.INT) {
                throw new ExecutionPlanCreationException("Calculation interval should be int, but found " + attributeExpressionExecutors[3].getReturnType());
            }
            this.calcInterval = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue();
            if (!(attributeExpressionExecutors[4] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanCreationException("Confidence interval must be a constant");
            if (attributeExpressionExecutors[4].getReturnType() != Attribute.Type.DOUBLE) throw new ExecutionPlanCreationException("Confidence interval should be double, but found " + attributeExpressionExecutors[4].getReturnType());
            this.ci = (Double)((ConstantExpressionExecutor)attributeExpressionExecutors[4]).getValue();
            if (!(0.0 <= this.ci) || !(this.ci <= 1.0)) {
                throw new ExecutionPlanCreationException("Confidence interval should be a value between 0 and 1");
            }
        }
        if (this.paramCount > 2) {
            throw new ExecutionPlanCreationException("Forecast Function is available only for simple linear regression");
        }
        this.regressionCalculator = new LengthTimeSimpleLinearRegressionCalculator(this.paramCount, this.duration, batchSize, this.calcInterval, this.ci);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.paramCount + 2);
        attributes.add(new Attribute("stderr", Attribute.Type.DOUBLE));
        for (int itr = 0; itr < this.paramCount; ++itr) {
            String betaVal = "beta" + itr;
            attributes.add(new Attribute(betaVal, Attribute.Type.DOUBLE));
        }
        attributes.add(new Attribute("forecastY", Attribute.Type.DOUBLE));
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        LengthTimeLinearRegressionForecastStreamProcessor lengthTimeLinearRegressionForecastStreamProcessor = this;
        synchronized (lengthTimeLinearRegressionForecastStreamProcessor) {
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
                long eventExpiryTime = currentTime + this.duration;
                Object[] inputData = new Object[this.paramCount];
                int xDashPosition = 2;
                double xDash = ((Number)this.attributeExpressionExecutors[xDashPosition].execute((ComplexEvent)streamEvent)).doubleValue();
                for (int i = this.yParameterPosition; i < this.attributeExpressionLength; ++i) {
                    inputData[i - this.yParameterPosition] = this.attributeExpressionExecutors[i].execute((ComplexEvent)streamEvent);
                }
                Object[] coefficients = this.regressionCalculator.calculateLinearRegression(inputData, eventExpiryTime);
                if (coefficients == null) {
                    streamEventChunk.remove();
                    continue;
                }
                Object[] outputData = new Object[coefficients.length + 1];
                System.arraycopy(coefficients, 0, outputData, 0, coefficients.length);
                outputData[coefficients.length] = ((Number)coefficients[coefficients.length - 2]).doubleValue() + ((Number)coefficients[coefficients.length - 1]).doubleValue() * xDash;
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, outputData);
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

