/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.exception;

import org.wso2.siddhi.query.api.exception.SiddhiAppContextException;
import org.wso2.siddhi.query.api.util.ExceptionUtil;

public class SiddhiAppValidationException
extends RuntimeException
implements SiddhiAppContextException {
    private String message;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;
    private String siddhiAppName = null;
    private String siddhiAppPortion = null;

    public SiddhiAppValidationException(String message) {
        super(message);
        this.message = message;
    }

    public SiddhiAppValidationException(String message, Throwable throwable) {
        super(message, throwable);
        this.message = message;
    }

    public SiddhiAppValidationException(Throwable throwable) {
        super(throwable);
    }

    public SiddhiAppValidationException(String message, int[] queryContextStartIndex, int[] queryContextEndIndex, String siddhiAppName, String siddhiAppString) {
        super(message);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, siddhiAppName, siddhiAppString);
    }

    public SiddhiAppValidationException(String message, Throwable throwable, int[] queryContextStartIndex, int[] queryContextEndIndex) {
        super(message, throwable);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, this.siddhiAppName, null);
    }

    public SiddhiAppValidationException(String message, int[] queryContextStartIndex, int[] queryContextEndIndex) {
        super(message);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, this.siddhiAppName, null);
    }

    public SiddhiAppValidationException(String message, Throwable throwable, int[] queryContextStartIndex, int[] queryContextEndIndex, String siddhiAppName, String siddhiAppString) {
        super(message, throwable);
        this.message = message;
        this.setQueryContextIndexIfAbsent(queryContextStartIndex, queryContextEndIndex, siddhiAppName, siddhiAppString);
    }

    @Override
    public void setQueryContextIndexIfAbsent(int[] queryContextStartIndex, int[] queryContextEndIndex, String siddhiAppName, String siddhiAppString) {
        if (this.siddhiAppName == null) {
            this.siddhiAppName = siddhiAppName;
        }
        if (this.queryContextStartIndex == null && this.queryContextEndIndex == null && queryContextStartIndex != null && queryContextEndIndex != null) {
            this.queryContextStartIndex = queryContextStartIndex;
            this.queryContextEndIndex = queryContextEndIndex;
        }
        if (this.siddhiAppPortion == null && this.queryContextStartIndex != null && this.queryContextEndIndex != null && siddhiAppString != null) {
            this.siddhiAppPortion = ExceptionUtil.getContext(this.queryContextStartIndex, this.queryContextEndIndex, siddhiAppString);
        }
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public String getMessageWithOutContext() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return ExceptionUtil.getMessageWithContext(this.siddhiAppName, this.queryContextStartIndex, this.queryContextEndIndex, this.siddhiAppPortion, this.message);
    }
}

