/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.selection;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.exception.DuplicateAttributeException;
import org.wso2.siddhi.query.api.exception.UnsupportedAttributeTypeException;
import org.wso2.siddhi.query.api.execution.query.selection.BasicSelector;
import org.wso2.siddhi.query.api.execution.query.selection.OrderByAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.expression.constant.LongConstant;

public class Selector
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private List<OutputAttribute> selectionList = new ArrayList<OutputAttribute>();
    private List<Variable> groupByList = new ArrayList<Variable>();
    private List<OrderByAttribute> orderByList = new ArrayList<OrderByAttribute>();
    private Expression havingExpression;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;
    private Constant limit;
    private Constant offset;

    public static Selector selector() {
        return new Selector();
    }

    public static BasicSelector basicSelector() {
        return new BasicSelector();
    }

    public Selector select(String rename, Expression expression) {
        OutputAttribute outputAttribute = new OutputAttribute(rename, expression);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    public Selector select(Variable variable) {
        OutputAttribute outputAttribute = new OutputAttribute(variable);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    private void checkSelection(OutputAttribute newAttribute) {
        for (OutputAttribute attribute : this.selectionList) {
            if (!attribute.getRename().equals(newAttribute.getRename())) continue;
            throw new DuplicateAttributeException(newAttribute.getRename() + " is already defined as an output attribute ", newAttribute.getQueryContextStartIndex(), attribute.getQueryContextEndIndex());
        }
    }

    public Selector having(Expression havingExpression) {
        this.havingExpression = havingExpression;
        return this;
    }

    public Selector groupBy(Variable variable) {
        this.groupByList.add(variable);
        return this;
    }

    public Selector addGroupByList(List<Variable> list) {
        if (list != null) {
            this.groupByList.addAll(list);
        }
        return this;
    }

    public Selector orderBy(Variable variable) {
        this.orderByList.add(new OrderByAttribute(variable));
        return this;
    }

    public Selector orderBy(Variable variable, OrderByAttribute.Order order) {
        this.orderByList.add(new OrderByAttribute(variable, order));
        return this;
    }

    public Selector addOrderByList(List<OrderByAttribute> list) {
        if (list != null) {
            this.orderByList.addAll(list);
        }
        return this;
    }

    public Selector limit(Constant constant) {
        if (constant instanceof IntConstant || constant instanceof LongConstant) {
            this.limit = constant;
            return this;
        }
        throw new UnsupportedAttributeTypeException("'limit' only supports int or long constants, but found '" + constant + "'");
    }

    public Selector offset(Constant constant) {
        if (constant instanceof IntConstant || constant instanceof LongConstant) {
            this.offset = constant;
            return this;
        }
        throw new UnsupportedAttributeTypeException("'offset' only supports int or long constants, but found '" + constant + "'");
    }

    public List<OutputAttribute> getSelectionList() {
        return this.selectionList;
    }

    public List<Variable> getGroupByList() {
        return this.groupByList;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public List<OrderByAttribute> getOrderByList() {
        return this.orderByList;
    }

    public Constant getLimit() {
        return this.limit;
    }

    public Constant getOffset() {
        return this.offset;
    }

    public Selector addSelectionList(List<OutputAttribute> projectionList) {
        for (OutputAttribute outputAttribute : projectionList) {
            this.checkSelection(outputAttribute);
            this.selectionList.add(outputAttribute);
        }
        return this;
    }

    public String toString() {
        return "Selector{selectionList=" + this.selectionList + ", groupByList=" + this.groupByList + ", havingExpression=" + this.havingExpression + ", orderByList=" + this.orderByList + ", limit=" + this.limit + ", offset=" + this.offset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selector selector = (Selector)o;
        if (this.selectionList != null ? !this.selectionList.equals(selector.selectionList) : selector.selectionList != null) {
            return false;
        }
        if (this.groupByList != null ? !this.groupByList.equals(selector.groupByList) : selector.groupByList != null) {
            return false;
        }
        if (this.orderByList != null ? !this.orderByList.equals(selector.orderByList) : selector.orderByList != null) {
            return false;
        }
        if (this.havingExpression != null ? !this.havingExpression.equals(selector.havingExpression) : selector.havingExpression != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(selector.limit) : selector.limit != null) {
            return false;
        }
        return this.offset != null ? this.offset.equals(selector.offset) : selector.offset == null;
    }

    public int hashCode() {
        int result = this.selectionList != null ? this.selectionList.hashCode() : 0;
        result = 31 * result + (this.groupByList != null ? this.groupByList.hashCode() : 0);
        result = 31 * result + (this.orderByList != null ? this.orderByList.hashCode() : 0);
        result = 31 * result + (this.havingExpression != null ? this.havingExpression.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }
}

