/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.stream;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.expression.Expression;

public class JoinInputStream
extends InputStream {
    private static final long serialVersionUID = 1L;
    private final Within within;
    private final Expression per;
    private InputStream leftInputStream;
    private Type type;
    private InputStream rightInputStream;
    private Expression onCompare;
    private EventTrigger trigger;

    public JoinInputStream(SingleInputStream leftInputStream, Type type, SingleInputStream rightInputStream, Expression onCompare, EventTrigger trigger, Within within, Expression per) {
        this.leftInputStream = leftInputStream;
        this.type = type;
        this.rightInputStream = rightInputStream;
        this.onCompare = onCompare;
        this.trigger = trigger;
        this.within = within;
        this.per = per;
    }

    public InputStream getLeftInputStream() {
        return this.leftInputStream;
    }

    public Type getType() {
        return this.type;
    }

    public InputStream getRightInputStream() {
        return this.rightInputStream;
    }

    public Expression getOnCompare() {
        return this.onCompare;
    }

    public EventTrigger getTrigger() {
        return this.trigger;
    }

    public Within getWithin() {
        return this.within;
    }

    public Expression getPer() {
        return this.per;
    }

    @Override
    public List<String> getAllStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (String streamId : this.leftInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        for (String streamId : this.rightInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        return list;
    }

    @Override
    public List<String> getUniqueStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (String streamId : this.leftInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        for (String streamId : this.rightInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinInputStream that = (JoinInputStream)o;
        if (this.leftInputStream != null ? !this.leftInputStream.equals(that.leftInputStream) : that.leftInputStream != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.rightInputStream != null ? !this.rightInputStream.equals(that.rightInputStream) : that.rightInputStream != null) {
            return false;
        }
        if (this.onCompare != null ? !this.onCompare.equals(that.onCompare) : that.onCompare != null) {
            return false;
        }
        if (this.trigger != that.trigger) {
            return false;
        }
        if (this.within != null ? !this.within.equals(that.within) : that.within != null) {
            return false;
        }
        return this.per != null ? this.per.equals(that.per) : that.per == null;
    }

    public int hashCode() {
        int result = this.leftInputStream != null ? this.leftInputStream.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.rightInputStream != null ? this.rightInputStream.hashCode() : 0);
        result = 31 * result + (this.onCompare != null ? this.onCompare.hashCode() : 0);
        result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
        result = 31 * result + (this.within != null ? this.within.hashCode() : 0);
        result = 31 * result + (this.per != null ? this.per.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JoinInputStream{leftInputStream=" + this.leftInputStream + ", type=" + (Object)((Object)this.type) + ", rightInputStream=" + this.rightInputStream + ", onCompare=" + this.onCompare + ", trigger=" + (Object)((Object)this.trigger) + ", within=" + this.within + ", per=" + this.per + '}';
    }

    public static enum EventTrigger {
        LEFT,
        RIGHT,
        ALL;

    }

    public static enum Type {
        JOIN,
        INNER_JOIN,
        LEFT_OUTER_JOIN,
        RIGHT_OUTER_JOIN,
        FULL_OUTER_JOIN;

    }
}

