/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.OutputRate;
import org.wso2.siddhi.query.api.execution.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateSet;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateStream;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;

public class Query
implements ExecutionElement,
SiddhiElement {
    private static final long serialVersionUID = 1L;
    private InputStream inputStream;
    private Selector selector = new Selector();
    private OutputStream outputStream = new ReturnStream();
    private OutputRate outputRate;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public static Query query() {
        return new Query();
    }

    public Query from(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Query select(Selector selector) {
        this.selector = selector;
        return this;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public Query outStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public Query insertInto(String outputStreamId, OutputStream.OutputEventType outputEventType) {
        this.outputStream = new InsertIntoStream(outputStreamId, outputEventType);
        return this;
    }

    public Query insertInto(String outputStreamId) {
        this.outputStream = new InsertIntoStream(outputStreamId);
        return this;
    }

    public Query insertIntoInner(String outputStreamId, OutputStream.OutputEventType outputEventType) {
        this.outputStream = new InsertIntoStream(outputStreamId, true, outputEventType);
        return this;
    }

    public Query insertIntoInner(String outputStreamId) {
        this.outputStream = new InsertIntoStream(outputStreamId, true);
        return this;
    }

    public Query insertIntoFault(String outputStreamId, OutputStream.OutputEventType outputEventType) {
        this.outputStream = new InsertIntoStream(outputStreamId, false, true, outputEventType);
        return this;
    }

    public Query insertIntoFault(String outputStreamId) {
        this.outputStream = new InsertIntoStream(outputStreamId, false, true);
        return this;
    }

    public Query returns() {
        this.outputStream = new ReturnStream();
        return this;
    }

    public Query returns(OutputStream.OutputEventType outputEventType) {
        this.outputStream = new ReturnStream(outputEventType);
        return this;
    }

    public void deleteBy(String outputTableId, Expression onDeletingExpression) {
        this.outputStream = new DeleteStream(outputTableId, onDeletingExpression);
    }

    public void deleteBy(String outputTableId, OutputStream.OutputEventType outputEventType, Expression onDeletingExpression) {
        this.outputStream = new DeleteStream(outputTableId, outputEventType, onDeletingExpression);
    }

    public void updateBy(String outputTableId, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, onUpdateExpression);
    }

    public void updateBy(String outputTableId, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, updateSetAttributes, onUpdateExpression);
    }

    public void updateBy(String outputTableId, OutputStream.OutputEventType outputEventType, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, outputEventType, null, onUpdateExpression);
    }

    public void updateBy(String outputTableId, OutputStream.OutputEventType outputEventType, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, outputEventType, updateSetAttributes, onUpdateExpression);
    }

    public void updateOrInsertBy(String outputTableId, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateOrInsertStream(outputTableId, updateSetAttributes, onUpdateExpression);
    }

    public void updateOrInsertBy(String outputTableId, OutputStream.OutputEventType outputEventType, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateOrInsertStream(outputTableId, outputEventType, updateSetAttributes, onUpdateExpression);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void output(OutputRate outputRate) {
        this.outputRate = outputRate;
    }

    public OutputRate getOutputRate() {
        return this.outputRate;
    }

    public Query annotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "Query{stream=" + this.inputStream + ", selector=" + this.selector + ", outputStream=" + this.outputStream + ", outputRate=" + this.outputRate + ", annotations=" + this.annotations + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query query = (Query)o;
        if (this.annotations != null ? !this.annotations.equals(query.annotations) : query.annotations != null) {
            return false;
        }
        if (this.inputStream != null ? !this.inputStream.equals(query.inputStream) : query.inputStream != null) {
            return false;
        }
        if (this.outputRate != null ? !this.outputRate.equals(query.outputRate) : query.outputRate != null) {
            return false;
        }
        if (this.outputStream != null ? !this.outputStream.equals(query.outputStream) : query.outputStream != null) {
            return false;
        }
        return !(this.selector != null ? !this.selector.equals(query.selector) : query.selector != null);
    }

    public int hashCode() {
        int result = this.inputStream != null ? this.inputStream.hashCode() : 0;
        result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
        result = 31 * result + (this.outputStream != null ? this.outputStream.hashCode() : 0);
        result = 31 * result + (this.outputRate != null ? this.outputRate.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }
}

