/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.aggregation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.siddhi.query.api.SiddhiElement;

public class TimePeriod
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private Operator operator;
    private List<Duration> durations = new ArrayList<Duration>();
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    private TimePeriod(Operator operator) {
        this.operator = operator;
    }

    public static TimePeriod range(Duration begging, Duration end) {
        TimePeriod timePeriod = new TimePeriod(Operator.RANGE);
        timePeriod.durations.add(begging);
        timePeriod.durations.add(end);
        return timePeriod;
    }

    public static TimePeriod interval(Duration ... durations) {
        TimePeriod timePeriod = new TimePeriod(Operator.INTERVAL);
        Collections.addAll(timePeriod.durations, durations);
        return timePeriod;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Duration> getDurations() {
        return this.durations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod that = (TimePeriod)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.durations != null ? this.durations.equals(that.durations) : that.durations == null;
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + (this.durations != null ? this.durations.hashCode() : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }

    public static enum Operator {
        RANGE,
        INTERVAL;

    }

    public static enum Duration {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        MONTHS,
        YEARS;

    }
}

