/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sp.open.tracer.client;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.sp.open.tracer.client.Utils;

final class AnalyticsSpan
implements Span {
    private static AtomicLong nextId = new AtomicLong();
    private AnalyticsSpanContext context;
    private final long parentId;
    private final long startMicros;
    private boolean finished;
    private final Map<String, Object> tags;
    private String operationName;
    private final List<Reference> references;
    private DataPublisher dataPublisher;
    private String componentName;

    public synchronized AnalyticsSpan setOperationName(String operationName) {
        this.finishedCheck("Setting operationName {%s} on already finished span", operationName);
        this.operationName = operationName;
        return this;
    }

    public synchronized AnalyticsSpanContext context() {
        return this.context;
    }

    public void finish() {
        this.finish(AnalyticsSpan.nowMicros());
    }

    public synchronized void finish(long finishMicros) {
        this.finishedCheck("Finishing already finished span", new Object[0]);
        this.finished = true;
        this.dataPublisher.publish(new Event("SpanStream:1.0.0", System.currentTimeMillis(), null, null, new Object[]{this.componentName, this.context.traceId, this.context.spanId, Utils.getJSONString(this.context.baggage), this.parentId, this.operationName, this.startMicros, finishMicros, Utils.getJSONString(this.tags), Utils.getJSONString(this.references)}));
    }

    public AnalyticsSpan setTag(String key, String value) {
        return this.setObjectTag(key, value);
    }

    public AnalyticsSpan setTag(String key, boolean value) {
        return this.setObjectTag(key, value);
    }

    public AnalyticsSpan setTag(String key, Number value) {
        return this.setObjectTag(key, value);
    }

    private synchronized AnalyticsSpan setObjectTag(String key, Object value) {
        this.finishedCheck("Adding tag {%s:%s} to already finished span", key, value);
        this.tags.put(key, value);
        return this;
    }

    public final Span log(Map<String, ?> fields) {
        return this.log(AnalyticsSpan.nowMicros(), (Map)fields);
    }

    public final synchronized AnalyticsSpan log(long timestampMicros, Map<String, ?> fields) {
        this.finishedCheck("Adding logs %s at %d to already finished span", fields, timestampMicros);
        return this;
    }

    public AnalyticsSpan log(String event) {
        return this.log(AnalyticsSpan.nowMicros(), event);
    }

    public AnalyticsSpan log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, (Map)Collections.singletonMap("event", event));
    }

    public synchronized Span setBaggageItem(String key, String value) {
        this.finishedCheck("Adding baggage {%s:%s} to already finished span", key, value);
        this.context = this.context.withBaggageItem(key, value);
        return this;
    }

    public synchronized String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    AnalyticsSpan(String operationName, long startMicros, Map<String, Object> initialTags, List<Reference> refs, DataPublisher dataPublisher, String componentName) {
        this.operationName = operationName;
        this.startMicros = startMicros;
        this.dataPublisher = dataPublisher;
        this.componentName = componentName;
        this.tags = initialTags == null ? new HashMap<String, Object>() : new HashMap<String, Object>(initialTags);
        this.references = refs == null ? Collections.emptyList() : new ArrayList<Reference>(refs);
        AnalyticsSpanContext parent = AnalyticsSpan.findPreferredParentRef(this.references);
        if (parent == null) {
            this.context = new AnalyticsSpanContext(this.generateTraceId(), this.nextId(), new HashMap<String, String>());
            this.parentId = 0L;
        } else {
            this.context = new AnalyticsSpanContext(parent.traceId, this.nextId(), AnalyticsSpan.mergeBaggages(this.references));
            this.parentId = parent.spanId;
        }
    }

    private String generateTraceId() {
        return UUID.randomUUID().toString();
    }

    private static AnalyticsSpanContext findPreferredParentRef(List<Reference> references) {
        if (references.isEmpty()) {
            return null;
        }
        for (Reference reference : references) {
            if (!"child_of".equals(reference.getReferenceType())) continue;
            return reference.getContext();
        }
        return references.get(0).getContext();
    }

    private static Map<String, String> mergeBaggages(List<Reference> references) {
        HashMap<String, String> baggage = new HashMap<String, String>();
        for (Reference ref : references) {
            if (ref.getContext().baggage == null) continue;
            baggage.putAll(ref.getContext().baggage);
        }
        return baggage;
    }

    private long nextId() {
        return nextId.incrementAndGet();
    }

    static long nowMicros() {
        return System.nanoTime();
    }

    private synchronized void finishedCheck(String format, Object ... args) {
        if (this.finished) {
            throw new IllegalStateException(String.format(format, args));
        }
    }

    public String toString() {
        return "{traceId:" + this.context.traceId() + ", spanId:" + this.context.spanId() + ", parentId:" + this.parentId + ", operationName:\"" + this.operationName + "\"}";
    }

    public static final class Reference {
        private final AnalyticsSpanContext context;
        private final String referenceType;

        Reference(AnalyticsSpanContext context, String referenceType) {
            this.context = context;
            this.referenceType = referenceType;
        }

        AnalyticsSpanContext getContext() {
            return this.context;
        }

        String getReferenceType() {
            return this.referenceType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reference reference = (Reference)o;
            return Objects.equals(this.context, reference.context) && Objects.equals(this.referenceType, reference.referenceType);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.referenceType);
        }
    }

    static final class AnalyticsSpanContext
    implements SpanContext {
        private final String traceId;
        private final Map<String, String> baggage;
        private final long spanId;

        AnalyticsSpanContext(String traceId, long spanId, Map<String, String> baggage) {
            this.baggage = baggage;
            this.traceId = traceId;
            this.spanId = spanId;
        }

        String getBaggageItem(String key) {
            return this.baggage.get(key);
        }

        String traceId() {
            return this.traceId;
        }

        long spanId() {
            return this.spanId;
        }

        AnalyticsSpanContext withBaggageItem(String key, String val) {
            HashMap<String, String> newBaggage = new HashMap<String, String>(this.baggage);
            newBaggage.put(key, val);
            return new AnalyticsSpanContext(this.traceId, this.spanId, newBaggage);
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            return this.baggage.entrySet();
        }
    }
}

