/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sp.open.tracer.client;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.sp.open.tracer.client.AnalyticsSpan;

public class AnalyticsTracer
implements Tracer {
    private Propagator propagator = Propagator.TEXT_MAP;
    private ScopeManager scopeManager;
    private DataPublisher dataPublisher;
    private String componentName;

    AnalyticsTracer(DataPublisher dataPublisher, String componentName, ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
        this.dataPublisher = dataPublisher;
        this.componentName = componentName;
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    public SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    private SpanContext activeSpanContext() {
        Scope scope = this.scopeManager.active();
        if (scope != null && scope.span() != null) {
            return scope.span().context();
        }
        return null;
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.propagator.inject((AnalyticsSpan.AnalyticsSpanContext)spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.propagator.extract(format, carrier, this.dataPublisher);
    }

    public final class SpanBuilder
    implements Tracer.SpanBuilder {
        private final String operationName;
        private long startMicros;
        private List<AnalyticsSpan.Reference> references = new ArrayList<AnalyticsSpan.Reference>();
        private boolean ignoringActiveSpan;
        private Map<String, Object> initialTags = new HashMap<String, Object>();

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public SpanBuilder asChildOf(SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public Tracer.SpanBuilder asChildOf(Span parent) {
            return this.addReference("child_of", parent != null ? parent.context() : null);
        }

        public SpanBuilder ignoreActiveSpan() {
            this.ignoringActiveSpan = true;
            return this;
        }

        public SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if (referencedContext != null) {
                this.references.add(new AnalyticsSpan.Reference((AnalyticsSpan.AnalyticsSpanContext)referencedContext, referenceType));
            }
            return this;
        }

        public SpanBuilder withTag(String key, String value) {
            this.initialTags.put(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, boolean value) {
            this.initialTags.put(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, Number value) {
            this.initialTags.put(key, value);
            return this;
        }

        public SpanBuilder withStartTimestamp(long microseconds) {
            this.startMicros = microseconds;
            return this;
        }

        public Scope startActive(boolean finishSpanOnClose) {
            return AnalyticsTracer.this.scopeManager.activate((Span)this.startManual(), finishSpanOnClose);
        }

        @Deprecated
        public AnalyticsSpan start() {
            return this.startManual();
        }

        public AnalyticsSpan startManual() {
            if (this.startMicros == 0L) {
                this.startMicros = AnalyticsSpan.nowMicros();
            }
            SpanContext activeSpanContext = AnalyticsTracer.this.activeSpanContext();
            if (this.references.isEmpty() && !this.ignoringActiveSpan && activeSpanContext != null) {
                this.references.add(new AnalyticsSpan.Reference((AnalyticsSpan.AnalyticsSpanContext)activeSpanContext, "child_of"));
            }
            return new AnalyticsSpan(this.operationName, this.startMicros, this.initialTags, this.references, AnalyticsTracer.this.dataPublisher, AnalyticsTracer.this.componentName);
        }
    }

    public static interface Propagator {
        public static final Propagator TEXT_MAP = new Propagator(){
            public static final String SPAN_ID_KEY = "spanid";
            public static final String TRACE_ID_KEY = "traceid";
            public static final String BAGGAGE_KEY_PREFIX = "baggage-";

            @Override
            public <C> void inject(AnalyticsSpan.AnalyticsSpanContext ctx, Format<C> format, C carrier) {
                TextMap textMap;
                if (carrier instanceof TextMap) {
                    textMap = (TextMap)carrier;
                    for (Map.Entry<String, String> entry : ctx.baggageItems()) {
                        textMap.put(BAGGAGE_KEY_PREFIX + entry.getKey(), entry.getValue());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown carrier");
                }
                textMap.put(SPAN_ID_KEY, String.valueOf(ctx.spanId()));
                textMap.put(TRACE_ID_KEY, String.valueOf(ctx.traceId()));
            }

            @Override
            public <C> AnalyticsSpan.AnalyticsSpanContext extract(Format<C> format, C carrier, DataPublisher dataPublisher) {
                String traceId = null;
                Long spanId = null;
                HashMap<String, String> baggage = new HashMap<String, String>();
                if (carrier instanceof TextMap) {
                    TextMap textMap = (TextMap)carrier;
                    for (Map.Entry entry : textMap) {
                        if (TRACE_ID_KEY.equals(entry.getKey())) {
                            traceId = (String)entry.getValue();
                            continue;
                        }
                        if (SPAN_ID_KEY.equals(entry.getKey())) {
                            spanId = Long.valueOf((String)entry.getValue());
                            continue;
                        }
                        if (!((String)entry.getKey()).startsWith(BAGGAGE_KEY_PREFIX)) continue;
                        String key = ((String)entry.getKey()).substring(BAGGAGE_KEY_PREFIX.length());
                        baggage.put(key, (String)entry.getValue());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown carrier");
                }
                if (traceId != null && spanId != null) {
                    return new AnalyticsSpan.AnalyticsSpanContext(traceId, spanId, baggage);
                }
                return null;
            }
        };

        public <C> void inject(AnalyticsSpan.AnalyticsSpanContext var1, Format<C> var2, C var3);

        public <C> AnalyticsSpan.AnalyticsSpanContext extract(Format<C> var1, C var2, DataPublisher var3);
    }
}

