/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sp.open.tracer.client;

import io.opentracing.ScopeManager;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.sp.open.tracer.client.AnalyticsTracer;
import org.wso2.sp.open.tracer.client.AnalyticsTracerConfig;
import org.wso2.sp.open.tracer.client.AnalyticsTracerInitializationException;

public class AnalyticsTracerLoader {
    private static AnalyticsTracerLoader instance = new AnalyticsTracerLoader();

    private AnalyticsTracerLoader() {
    }

    public static AnalyticsTracerLoader getInstance() {
        return instance;
    }

    public AnalyticsTracer getTracer(AnalyticsTracerConfig config, ScopeManager scopeManager) throws AnalyticsTracerInitializationException {
        try {
            DataPublisher dataPublisher = new DataPublisher(config.getType(), config.getAnalyticsURL(), config.getAnalyticsAuthURL(), config.getAnalyticsUserName(), config.getAnalyticsPassword());
            return new AnalyticsTracer(dataPublisher, config.getServiceName(), scopeManager);
        }
        catch (DataEndpointAgentConfigurationException | DataEndpointAuthenticationException | DataEndpointConfigurationException | DataEndpointException | TransportException e) {
            throw new AnalyticsTracerInitializationException("Error while initializing the data publisher for the analytics tracer.", (Exception)e);
        }
    }
}

