/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sp.open.tracer.client;

import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import java.util.Properties;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.sp.open.tracer.client.AnalyticsTracer;
import org.wso2.sp.open.tracer.client.AnalyticsTracerConfig;
import org.wso2.sp.open.tracer.client.AnalyticsTracerInitializationException;
import org.wso2.sp.open.tracer.client.AnalyticsTracerLoader;
import org.wso2.sp.open.tracer.client.InvalidTracerConfigurationException;

public class StreamProcessorTracerClient {
    private Properties properties;

    public void init(Properties properties) throws InvalidTracerConfigurationException {
        this.properties = properties;
        if (!properties.getProperty("trace.name").equalsIgnoreCase("wso2sp")) {
            throw new InvalidTracerConfigurationException("Unexpected tracer name! The tracer name supported by this extension is : trace.name but found : " + properties.getProperty("trace.name"));
        }
        this.validateConfiguration(properties);
        System.setProperty("javax.net.ssl.trustStore", properties.getProperty("javax.net.ssl.trustStore"));
        System.setProperty("javax.net.ssl.trustStorePassword", properties.getProperty("javax.net.ssl.trustStorePassword"));
        AgentHolder.setConfigPath((String)properties.getProperty("reporter.wso2sp.publisher.databridge.agent.config"));
    }

    public Tracer getTracer(String serviceName, ScopeManager scopeManager) throws AnalyticsTracerInitializationException {
        AnalyticsTracerConfig tracerConfig = new AnalyticsTracerConfig(this.properties.getProperty("reporter.wso2sp.publisher.type"), this.properties.getProperty("reporter.wso2sp.publisher.url"), this.properties.getProperty("reporter.wso2sp.publisher.authUrl"), this.properties.getProperty("reporter.wso2sp.publisher.username"), this.properties.getProperty("reporter.wso2sp.publisher.password"), serviceName);
        AnalyticsTracer tracer = AnalyticsTracerLoader.getInstance().getTracer(tracerConfig, scopeManager);
        return tracer;
    }

    private void validateConfiguration(Properties configuration) throws InvalidTracerConfigurationException {
        this.setValidatedStringConfig(configuration, "reporter.wso2sp.publisher.username", "admin");
        this.setValidatedStringConfig(configuration, "reporter.wso2sp.publisher.password", "admin");
        this.setValidatedStringConfig(configuration, "reporter.wso2sp.publisher.url", "tcp://localhost:7611");
        this.setValidatedStringConfig(configuration, "reporter.wso2sp.publisher.authUrl", "ssl://localhost:7711");
        this.setValidatedStringConfig(configuration, "reporter.wso2sp.publisher.type", "Thrift");
        if (null == configuration.getProperty("reporter.wso2sp.publisher.databridge.agent.config")) {
            throw new InvalidTracerConfigurationException("Databridge agent config location is needed for tracer: trace.name.");
        }
        if (null == configuration.getProperty("javax.net.ssl.trustStore")) {
            throw new InvalidTracerConfigurationException("Truststore location is needed for tracer: trace.name.");
        }
    }

    private void setValidatedStringConfig(Properties configuration, String configName, String defaultValue) {
        Object configValue = configuration.get(configName);
        if (configValue == null || configValue.toString().trim().isEmpty()) {
            configuration.put(configName, defaultValue);
        } else {
            configuration.put(configName, configValue.toString().trim());
        }
    }
}

