/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.word.function;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="word", namespace="filter", description="Returns the word if the given word is meaningful, otherwise returns null", parameters={@Parameter(name="input.string", description="The input string to check whether given word is meaningful.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Outputs the given word if it is meaningful.", type={DataType.STRING})}, examples={@Example(description="This outputs the given words if it is meaningful. In this scenario, the output is 'shopping' .", syntax="word(\"shopping\")")})
public class WordFunction
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(WordFunction.class);
    private Attribute.Type returnType = Attribute.Type.BOOL;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to filter:word() function. Required 1. Found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for filter:word() function, required " + Attribute.Type.STRING + ", " + "but found " + attributeExpressionExecutors[0].getReturnType());
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object execute(Object data) {
        if (data == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to filter:word() function. The argument cannot be null");
        }
        InputStream inputStream = WordFunction.class.getResourceAsStream("/words.csv");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            do {
                if ((line = bufferedReader.readLine()) == null) return true;
            } while (!line.equalsIgnoreCase(data.toString()));
            Boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File is not found : " + e.getMessage()));
            return true;
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while reading file : " + e.getMessage()));
        }
        return true;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

