/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.Http2Reset;

public class ClientFrameListener
extends Http2EventAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientFrameListener.class);
    private Http2ClientChannel http2ClientChannel;

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading data on channel: {} with stream id: {}, isEndOfStream: {}", new Object[]{this.http2ClientChannel, streamId, endOfStream});
        }
        for (Http2DataEventListener listener : this.http2ClientChannel.getDataEventListeners()) {
            if (listener.onDataRead(ctx, streamId, data, endOfStream)) continue;
            return 0;
        }
        Http2DataFrame dataFrame = new Http2DataFrame(streamId, data, endOfStream);
        ctx.fireChannelRead((Object)dataFrame);
        return 0;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        this.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading Http2 headers on channel: {} with stream id: {}, isEndOfStream: {}", new Object[]{this.http2ClientChannel, streamId, endStream});
        }
        for (Http2DataEventListener listener : this.http2ClientChannel.getDataEventListeners()) {
            if (listener.onHeadersRead(ctx, streamId, headers, endStream)) continue;
            return;
        }
        Http2HeadersFrame http2HeadersFrame = new Http2HeadersFrame(streamId, headers, endStream);
        ctx.fireChannelRead((Object)http2HeadersFrame);
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        LOG.debug("Http2FrameListenAdapter.onSettingRead()");
        ctx.fireChannelRead((Object)settings);
        super.onSettingsRead(ctx, settings);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        LOG.warn("RST received on channel: {} for streamId: {} errorCode: {}", new Object[]{this.http2ClientChannel, streamId, errorCode});
        Http2Reset http2Reset = new Http2Reset(streamId, Http2Error.valueOf((long)errorCode));
        ctx.fireChannelRead((Object)http2Reset);
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received a push promise on channel: {} over stream id: {}, promisedStreamId: {}", new Object[]{this.http2ClientChannel, streamId, promisedStreamId});
        }
        for (Http2DataEventListener listener : this.http2ClientChannel.getDataEventListeners()) {
            if (listener.onPushPromiseRead(ctx, streamId, headers, false)) continue;
            return;
        }
        Http2PushPromise pushPromise = new Http2PushPromise(Util.createHttpRequestFromHttp2Headers(headers, streamId));
        pushPromise.setPromisedStreamId(promisedStreamId);
        pushPromise.setStreamId(streamId);
        ctx.fireChannelRead((Object)pushPromise);
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.http2ClientChannel.destroy();
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.http2ClientChannel.destroy();
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2ClientChannel = http2ClientChannel;
    }
}

