/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.common.HttpRoute;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.sender.ConnectionAvailabilityListener;
import org.wso2.transport.http.netty.contractimpl.sender.channel.BootstrapConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientTimeoutHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.http2.RequestWriteStarter;
import org.wso2.transport.http.netty.contractimpl.sender.states.SendingHeaders;
import org.wso2.transport.http.netty.message.ClientRemoteFlowControlListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.Http2Reset;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.ResponseHandle;

public class DefaultHttpClientConnector
implements HttpClientConnector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientConnector.class);
    private ConnectionManager connectionManager;
    private Http2ConnectionManager http2ConnectionManager;
    private SenderConfiguration senderConfiguration;
    private SSLConfig sslConfig;
    private int socketIdleTimeout;
    private String httpVersion;
    private ChunkConfig chunkConfig;
    private boolean isHttp2;
    private ForwardedExtensionConfig forwardedExtensionConfig;
    private EventLoopGroup clientEventGroup;
    private BootstrapConfiguration bootstrapConfig;

    public DefaultHttpClientConnector(ConnectionManager connectionManager, SenderConfiguration senderConfiguration, BootstrapConfiguration bootstrapConfig, EventLoopGroup clientEventGroup) {
        this.connectionManager = connectionManager;
        this.http2ConnectionManager = connectionManager.getHttp2ConnectionManager();
        this.senderConfiguration = senderConfiguration;
        this.initTargetChannelProperties(senderConfiguration);
        if ("2.0".equals(senderConfiguration.getHttpVersion())) {
            this.isHttp2 = true;
        }
        this.clientEventGroup = clientEventGroup;
        this.bootstrapConfig = bootstrapConfig;
    }

    @Override
    public HttpResponseFuture connect() {
        return null;
    }

    @Override
    public HttpResponseFuture getResponse(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public HttpResponseFuture getNextPushPromise(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public HttpResponseFuture hasPushPromise(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public void rejectPushResponse(Http2PushPromise pushPromise) {
        Http2Reset http2Reset = new Http2Reset(pushPromise.getPromisedStreamId());
        OutboundMsgHolder outboundMsgHolder = pushPromise.getOutboundMsgHolder();
        pushPromise.reject();
        outboundMsgHolder.getHttp2ClientChannel().getChannel().write((Object)http2Reset);
    }

    @Override
    public HttpResponseFuture getPushResponse(Http2PushPromise pushPromise) {
        OutboundMsgHolder outboundMsgHolder = pushPromise.getOutboundMsgHolder();
        if (pushPromise.isRejected()) {
            outboundMsgHolder.getResponseFuture().notifyPushResponse(pushPromise.getPromisedStreamId(), new ClientConnectorException("Cannot fetch a response for an rejected promise", HttpResponseStatus.BAD_REQUEST.code()));
        }
        return outboundMsgHolder.getResponseFuture();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public HttpResponseFuture send(HttpCarbonMessage httpOutboundRequest) {
        OutboundMsgHolder outboundMsgHolder = new OutboundMsgHolder(httpOutboundRequest);
        return this.send(outboundMsgHolder, httpOutboundRequest);
    }

    public HttpResponseFuture send(final OutboundMsgHolder outboundMsgHolder, final HttpCarbonMessage httpOutboundRequest) {
        HttpResponseFuture httpResponseFuture;
        Object sourceHandlerObject = httpOutboundRequest.getProperty("SRC_HANDLER");
        SourceHandler srcHandler = null;
        Http2SourceHandler http2SourceHandler = null;
        if (sourceHandlerObject != null) {
            if (sourceHandlerObject instanceof SourceHandler) {
                srcHandler = (SourceHandler)((Object)sourceHandlerObject);
            } else if (sourceHandlerObject instanceof Http2SourceHandler) {
                http2SourceHandler = (Http2SourceHandler)((Object)sourceHandlerObject);
            }
        }
        final SourceHandler http1xSrcHandlder = srcHandler;
        final Http2SourceHandler http2SrcHandler = http2SourceHandler;
        if (srcHandler == null && http2SourceHandler == null && LOG.isDebugEnabled()) {
            LOG.debug("SRC_HANDLER property not found in the message. Message is not originated from the HTTP Server connector");
        }
        try {
            Http2ClientChannel activeHttp2ClientChannel;
            final HttpRoute route = this.getTargetRoute(this.senderConfiguration.getScheme(), httpOutboundRequest);
            if (this.isHttp2 && (activeHttp2ClientChannel = this.http2ConnectionManager.borrowChannel(http2SourceHandler, route)) != null) {
                outboundMsgHolder.setHttp2ClientChannel(activeHttp2ClientChannel);
                this.setHttp2ForwardedExtension(outboundMsgHolder);
                new RequestWriteStarter(outboundMsgHolder, activeHttp2ClientChannel).startWritingContent();
                HttpResponseFuture httpResponseFuture2 = outboundMsgHolder.getResponseFuture();
                httpResponseFuture2.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                return httpResponseFuture2;
            }
            final TargetChannel targetChannel = this.connectionManager.borrowTargetChannel(route, srcHandler, http2SourceHandler, this.senderConfiguration, this.bootstrapConfig, this.clientEventGroup);
            final Http2ClientChannel freshHttp2ClientChannel = targetChannel.getHttp2ClientChannel();
            outboundMsgHolder.setHttp2ClientChannel(freshHttp2ClientChannel);
            httpResponseFuture = outboundMsgHolder.getResponseFuture();
            targetChannel.getConnectionReadyFuture().setListener(new ConnectionAvailabilityListener(){

                @Override
                public void onSuccess(String protocol, ChannelFuture channelFuture) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created the connection to address: {}", (Object)(route.toString() + " Original Channel ID is : " + channelFuture.channel().id()));
                    }
                    if ("http".equalsIgnoreCase(protocol) && http1xSrcHandlder != null) {
                        channelFuture.channel().deregister().addListener(future -> http1xSrcHandlder.getEventLoop().register(channelFuture.channel()).addListener(future1 -> this.startExecutingOutboundRequest(protocol, channelFuture)));
                    } else if ("http".equalsIgnoreCase(protocol) && http2SrcHandler != null) {
                        channelFuture.channel().deregister().addListener(future -> http2SrcHandler.getChannelHandlerContext().channel().eventLoop().register(channelFuture.channel()).addListener(future1 -> this.startExecutingOutboundRequest(protocol, channelFuture)));
                    } else {
                        this.startExecutingOutboundRequest(protocol, channelFuture);
                    }
                }

                private void startExecutingOutboundRequest(String protocol, ChannelFuture channelFuture) {
                    if (protocol.equalsIgnoreCase("h2c") || protocol.equalsIgnoreCase("h2")) {
                        this.prepareTargetChannelForHttp2();
                    } else {
                        this.prepareTargetChannelForHttp(channelFuture);
                        if (protocol.equalsIgnoreCase("http") && DefaultHttpClientConnector.this.senderConfiguration.getProxyServerConfiguration() != null) {
                            httpOutboundRequest.setProperty("IS_PROXY_ENABLED", true);
                        }
                        targetChannel.writeContent(httpOutboundRequest);
                    }
                }

                private void prepareTargetChannelForHttp2() {
                    freshHttp2ClientChannel.setSocketIdleTimeout(DefaultHttpClientConnector.this.socketIdleTimeout);
                    DefaultHttpClientConnector.this.connectionManager.getHttp2ConnectionManager().addHttp2ClientChannel(freshHttp2ClientChannel.getChannel().eventLoop(), route, freshHttp2ClientChannel);
                    ((Http2RemoteFlowController)freshHttp2ClientChannel.getConnection().remote().flowController()).listener((Http2RemoteFlowController.Listener)new ClientRemoteFlowControlListener(freshHttp2ClientChannel));
                    freshHttp2ClientChannel.addDataEventListener("idleStateHandler", new Http2ClientTimeoutHandler(DefaultHttpClientConnector.this.socketIdleTimeout, freshHttp2ClientChannel));
                    DefaultHttpClientConnector.this.setHttp2ForwardedExtension(outboundMsgHolder);
                    new RequestWriteStarter(outboundMsgHolder, freshHttp2ClientChannel).startWritingContent();
                    httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                }

                private void prepareTargetChannelForHttp(ChannelFuture channelFuture) {
                    freshHttp2ClientChannel.putInFlightMessage(1, outboundMsgHolder);
                    httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                    targetChannel.getHttp2ClientChannel().setSocketIdleTimeout(DefaultHttpClientConnector.this.socketIdleTimeout);
                    Channel targetNettyChannel = channelFuture.channel();
                    this.initializeSenderReqRespStateMgr(targetNettyChannel);
                    targetChannel.setChannel(targetNettyChannel);
                    targetChannel.configTargetHandler(httpOutboundRequest, httpResponseFuture);
                    httpResponseFuture.setBackPressureHandler(targetChannel.getBackPressureHandler());
                    Util.setCorrelationIdForLogging(targetNettyChannel.pipeline(), targetChannel.getCorrelatedSource());
                    Util.handleOutboundConnectionHeader(DefaultHttpClientConnector.this.senderConfiguration, httpOutboundRequest);
                    String localAddress = ((InetSocketAddress)targetNettyChannel.localAddress()).getAddress().getHostAddress();
                    Util.setForwardedExtension(DefaultHttpClientConnector.this.forwardedExtensionConfig, localAddress, httpOutboundRequest);
                }

                private void initializeSenderReqRespStateMgr(Channel targetNettyChannel) {
                    SenderReqRespStateManager senderReqRespStateManager = new SenderReqRespStateManager(targetNettyChannel, DefaultHttpClientConnector.this.socketIdleTimeout);
                    senderReqRespStateManager.state = new SendingHeaders(senderReqRespStateManager, targetChannel, DefaultHttpClientConnector.this.httpVersion, DefaultHttpClientConnector.this.chunkConfig, httpResponseFuture);
                    targetChannel.senderReqRespStateManager = senderReqRespStateManager;
                }

                @Override
                public void onFailure(ClientConnectorException cause) {
                    httpResponseFuture.notifyHttpListener(cause);
                    httpOutboundRequest.setIoException(new IOException("Remote host closed the connection before initiating outbound request"));
                }
            });
        }
        catch (NoSuchElementException failedCause) {
            if ("Timeout waiting for idle object".equals(failedCause.getMessage())) {
                failedCause = new NoSuchElementException("Could not obtain a connection within maximum wait time");
            }
            return this.notifyListenerAndGetErrorResponseFuture(failedCause);
        }
        catch (Exception failedCause) {
            return this.notifyListenerAndGetErrorResponseFuture(failedCause);
        }
        return httpResponseFuture;
    }

    private void setHttp2ForwardedExtension(OutboundMsgHolder outboundMsgHolder) {
        String localAddress = ((InetSocketAddress)outboundMsgHolder.getHttp2ClientChannel().getChannel().localAddress()).getAddress().getHostAddress();
        Util.setForwardedExtension(this.forwardedExtensionConfig, localAddress, outboundMsgHolder.getRequest());
    }

    private HttpResponseFuture notifyListenerAndGetErrorResponseFuture(Exception failedCause) {
        DefaultHttpResponseFuture errorResponseFuture = new DefaultHttpResponseFuture();
        errorResponseFuture.notifyHttpListener(failedCause);
        return errorResponseFuture;
    }

    private HttpRoute getTargetRoute(String scheme, HttpCarbonMessage httpCarbonMessage) {
        String host = this.fetchHost(httpCarbonMessage);
        int port = this.fetchPort(httpCarbonMessage);
        return new HttpRoute(scheme, host, port);
    }

    private int fetchPort(HttpCarbonMessage httpCarbonMessage) {
        int port;
        Object intProperty = httpCarbonMessage.getProperty("port");
        if (intProperty instanceof Integer) {
            port = (Integer)intProperty;
        } else {
            port = this.sslConfig != null ? 443 : 80;
            httpCarbonMessage.setProperty("port", port);
            LOG.debug("Cannot find property PORT of type integer, hence using {}", (Object)port);
        }
        return port;
    }

    private String fetchHost(HttpCarbonMessage httpCarbonMessage) {
        String host;
        Object hostProperty = httpCarbonMessage.getProperty("host");
        if (hostProperty instanceof String) {
            host = (String)hostProperty;
        } else {
            host = "localhost";
            httpCarbonMessage.setProperty("host", "localhost");
            LOG.debug("Cannot find property HOST of type string, hence using localhost as the host");
        }
        return host;
    }

    private void initTargetChannelProperties(SenderConfiguration senderConfiguration) {
        this.httpVersion = senderConfiguration.getHttpVersion();
        this.chunkConfig = senderConfiguration.getChunkingConfig();
        this.socketIdleTimeout = senderConfiguration.getSocketIdleTimeout(300000);
        this.sslConfig = senderConfiguration.getClientSSLConfig();
        this.forwardedExtensionConfig = senderConfiguration.getForwardedExtensionConfig();
    }
}

