/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2ServerChannel;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingHeaders;
import org.wso2.transport.http.netty.message.BackPressureObservable;
import org.wso2.transport.http.netty.message.DefaultBackPressureListener;
import org.wso2.transport.http.netty.message.DefaultBackPressureObservable;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.Http2InboundContentListener;
import org.wso2.transport.http.netty.message.Http2PassthroughBackPressureListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PassthroughBackPressureListener;
import org.wso2.transport.http.netty.message.ServerRemoteFlowControlListener;

public class Http2OutboundRespListener
implements HttpConnectorListener {
    private static final Logger LOG = LoggerFactory.getLogger(Http2OutboundRespListener.class);
    private Http2MessageStateContext http2MessageStateContext;
    private HttpCarbonMessage inboundRequestMsg;
    private HttpCarbonMessage outboundResponseMsg;
    private ChannelHandlerContext ctx;
    private Http2ConnectionEncoder encoder;
    private int originalStreamId;
    private Http2Connection conn;
    private String serverName;
    private HttpResponseFuture outboundRespStatusFuture;
    private HttpServerChannelInitializer serverChannelInitializer;
    private Calendar inboundRequestArrivalTime;
    private String remoteAddress = "-";
    private ServerRemoteFlowControlListener remoteFlowControlListener;
    private ResponseWriter defaultResponseWriter;
    private Http2ServerChannel http2ServerChannel;

    public Http2OutboundRespListener(HttpServerChannelInitializer serverChannelInitializer, HttpCarbonMessage inboundRequestMsg, ChannelHandlerContext ctx, Http2Connection conn, Http2ConnectionEncoder encoder, int streamId, String serverName, String remoteAddress, ServerRemoteFlowControlListener remoteFlowControlListener, Http2ServerChannel http2ServerChannel) {
        this.serverChannelInitializer = serverChannelInitializer;
        this.inboundRequestMsg = inboundRequestMsg;
        this.ctx = ctx;
        this.conn = conn;
        this.encoder = encoder;
        this.originalStreamId = streamId;
        this.serverName = serverName;
        if (remoteAddress != null) {
            this.remoteAddress = remoteAddress;
        }
        this.outboundRespStatusFuture = inboundRequestMsg.getHttpOutboundRespStatusFuture();
        this.inboundRequestArrivalTime = Calendar.getInstance();
        this.http2MessageStateContext = inboundRequestMsg.getHttp2MessageStateContext();
        this.remoteFlowControlListener = remoteFlowControlListener;
        this.http2ServerChannel = http2ServerChannel;
    }

    @Override
    public void onMessage(HttpCarbonMessage outboundResponseMsg) {
        this.outboundResponseMsg = outboundResponseMsg;
        this.writeMessage(outboundResponseMsg, this.originalStreamId, true);
    }

    @Override
    public void onError(Throwable throwable) {
        LOG.error("Couldn't send the outbound response", throwable);
    }

    @Override
    public void onPushPromise(Http2PushPromise pushPromise) {
        this.writePromise(pushPromise);
    }

    @Override
    public void onPushResponse(int promiseId, HttpCarbonMessage outboundResponseMsg) {
        if (Http2StateUtil.isValidStreamId(promiseId, this.conn)) {
            this.writeMessage(outboundResponseMsg, promiseId, false);
        } else {
            this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new ServerConnectorException("Promised stream is already rejected or stream is no longer valid"));
        }
    }

    private void writePromise(Http2PushPromise pushPromise) {
        this.ctx.channel().eventLoop().execute(() -> {
            try {
                if (this.http2MessageStateContext == null) {
                    this.http2MessageStateContext = new Http2MessageStateContext();
                    this.http2MessageStateContext.setListenerState(new EntityBodyReceived(this.http2MessageStateContext));
                }
                this.http2MessageStateContext.getListenerState().writeOutboundPromise(this, pushPromise);
            }
            catch (Http2Exception ex) {
                LOG.error("Failed to send push promise : " + ex.getMessage(), (Throwable)ex);
                this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(ex);
            }
        });
    }

    private void writeMessage(HttpCarbonMessage outboundResponseMsg, int streamId, boolean backOffEnabled) {
        ResponseWriter writer = new ResponseWriter(streamId);
        if (backOffEnabled) {
            this.remoteFlowControlListener.addResponseWriter(writer);
            this.defaultResponseWriter = writer;
        }
        this.setBackPressureListener(outboundResponseMsg, writer);
        this.setContentEncoding(outboundResponseMsg);
        outboundResponseMsg.getHttpContentAsync().setMessageListener(httpContent -> {
            this.checkStreamUnwritability(writer);
            this.ctx.channel().eventLoop().execute(() -> {
                try {
                    writer.writeOutboundResponse(outboundResponseMsg, httpContent);
                }
                catch (Http2Exception ex) {
                    LOG.error("Failed to send the outbound response : " + ex.getMessage(), (Throwable)ex);
                    this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(ex);
                }
            });
        });
    }

    private void setContentEncoding(HttpCarbonMessage outboundResponseMsg) {
        String acceptEncoding;
        String contentEncoding = outboundResponseMsg.getHeader(HttpHeaderNames.CONTENT_ENCODING.toString());
        if (contentEncoding == null && (acceptEncoding = this.inboundRequestMsg.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString())) != null) {
            outboundResponseMsg.setHeader(HttpHeaderNames.CONTENT_ENCODING.toString(), acceptEncoding);
        }
    }

    private void setBackPressureListener(HttpCarbonMessage outboundResponseMsg, ResponseWriter writer) {
        if (outboundResponseMsg.isPassthrough()) {
            this.setPassthroughBackOffListener(outboundResponseMsg, writer);
        } else {
            writer.getBackPressureObservable().setListener(new DefaultBackPressureListener());
        }
    }

    private void setPassthroughBackOffListener(HttpCarbonMessage outboundResponseMsg, ResponseWriter writer) {
        Listener inboundListener = outboundResponseMsg.getListener();
        if (inboundListener instanceof Http2InboundContentListener) {
            writer.getBackPressureObservable().setListener(new Http2PassthroughBackPressureListener((Http2InboundContentListener)inboundListener));
        } else if (inboundListener instanceof DefaultListener) {
            writer.getBackPressureObservable().setListener(new PassthroughBackPressureListener(outboundResponseMsg.getTargetContext()));
        }
    }

    private void checkStreamUnwritability(ResponseWriter writer) {
        if (!writer.isStreamWritable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("In thread {}. Stream is not writable.", (Object)Thread.currentThread().getName());
            }
            writer.getBackPressureObservable().notifyUnWritable();
        }
    }

    public void resetStream(ChannelHandlerContext ctx, int streamId, Http2Error http2Error) throws Http2Exception {
        this.encoder.writeRstStream(ctx, streamId, http2Error.code(), ctx.newPromise());
        this.encoder.flowController().writePendingBytes();
        this.http2ServerChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamReset(streamId));
        ctx.flush();
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public Http2ConnectionEncoder getEncoder() {
        return this.encoder;
    }

    public HttpResponseFuture getOutboundRespStatusFuture() {
        return this.outboundRespStatusFuture;
    }

    public HttpServerChannelInitializer getServerChannelInitializer() {
        return this.serverChannelInitializer;
    }

    public HttpCarbonMessage getInboundRequestMsg() {
        return this.inboundRequestMsg;
    }

    public HttpCarbonMessage getOutboundResponseMsg() {
        return this.outboundResponseMsg;
    }

    public Http2Connection getConnection() {
        return this.conn;
    }

    public Calendar getInboundRequestArrivalTime() {
        return this.inboundRequestArrivalTime;
    }

    public int getOriginalStreamId() {
        return this.originalStreamId;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void removeDefaultResponseWriter() {
        this.remoteFlowControlListener.removeResponseWriter(this.defaultResponseWriter);
    }

    public void removeBackPressureListener() {
        this.defaultResponseWriter.getBackPressureObservable().removeListener();
    }

    public Http2ServerChannel getHttp2ServerChannel() {
        return this.http2ServerChannel;
    }

    public class ResponseWriter {
        private int streamId;
        private AtomicBoolean streamWritable = new AtomicBoolean(true);
        private final BackPressureObservable backPressureObservable = new DefaultBackPressureObservable();

        ResponseWriter(int streamId) {
            this.streamId = streamId;
        }

        private void writeOutboundResponse(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) throws Http2Exception {
            if (Http2OutboundRespListener.this.http2MessageStateContext == null) {
                Http2OutboundRespListener.this.http2MessageStateContext = new Http2MessageStateContext();
                Http2OutboundRespListener.this.http2MessageStateContext.setListenerState(new SendingHeaders(Http2OutboundRespListener.this, Http2OutboundRespListener.this.http2MessageStateContext));
            }
            Http2OutboundRespListener.this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(Http2OutboundRespListener.this, outboundResponseMsg, httpContent, this.streamId);
        }

        public int getStreamId() {
            return this.streamId;
        }

        public void setStreamWritable(boolean streamWritable) {
            this.streamWritable.set(streamWritable);
        }

        boolean isStreamWritable() {
            return this.streamWritable.get();
        }

        public BackPressureObservable getBackPressureObservable() {
            return this.backPressureObservable;
        }
    }
}

