/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.http2;

import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.common.FrameLogger;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceConnectionHandler;

public final class Http2SourceConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2SourceConnectionHandler, Http2SourceConnectionHandlerBuilder> {
    private String interfaceId;
    private ServerConnectorFuture serverConnectorFuture;
    private String serverName;
    private HttpServerChannelInitializer serverChannelInitializer;

    public Http2SourceConnectionHandlerBuilder(String interfaceId, ServerConnectorFuture serverConnectorFuture, String serverName, HttpServerChannelInitializer serverChannelInitializer) {
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.serverName = serverName;
        this.serverChannelInitializer = serverChannelInitializer;
    }

    public Http2SourceConnectionHandler build() {
        DefaultHttp2Connection conn = new DefaultHttp2Connection(true);
        if (this.serverChannelInitializer.isHttpTraceLogEnabled()) {
            this.frameLogger(new FrameLogger(LogLevel.TRACE, "http.tracelog.downstream"));
        }
        this.connection((Http2Connection)conn);
        Http2SourceConnectionHandler connectionHandler = (Http2SourceConnectionHandler)super.build();
        if (connectionHandler != null) {
            return connectionHandler;
        }
        return null;
    }

    public Http2SourceConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        CompressorHttp2ConnectionEncoder compressEncoder = new CompressorHttp2ConnectionEncoder(encoder, new CompressionOptions[]{StandardCompressionOptions.gzip(), StandardCompressionOptions.deflate()});
        Http2SourceConnectionHandler sourceConnectionHandler = new Http2SourceConnectionHandler(this.serverChannelInitializer, decoder, (Http2ConnectionEncoder)compressEncoder, initialSettings, this.interfaceId, this.serverConnectorFuture, this.serverName);
        this.frameListener(sourceConnectionHandler.getHttp2FrameListener());
        return sourceConnectionHandler;
    }
}

