/*
 * Decompiled with CFR 0.152.
 */
package org.wuokko.robot.restlib;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Request;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.wuokko.robot.restlib.Diff;
import org.wuokko.robot.restlib.JsonDiff;
import org.wuokko.robot.restlib.exception.JsonElementNotFoundException;
import org.wuokko.robot.restlib.exception.JsonNotEqualException;
import org.wuokko.robot.restlib.exception.JsonNotValidException;

@RobotKeywords
public class JsonPathLibrary {
    private Diff diff = new JsonDiff();
    private static final String DEFAULT_PROPERTIES_FILE = "robot-rest-lib.properties";
    private static final int MAX_CACHE_SIZE = 100;
    private static int CONNECTION_TIMEOUT = 1000;
    private Map<URI, String> uriCache = Collections.synchronizedMap(new LRUMap(100));
    private Boolean useCache = Boolean.valueOf(System.getProperty("use.uri.cache"));
    private Configuration config;

    public JsonPathLibrary() {
        this.loadProperties(DEFAULT_PROPERTIES_FILE);
    }

    public JsonPathLibrary(String propertiesFile) {
        this.loadProperties(propertiesFile);
    }

    protected void loadProperties(String propertiesFile) {
        try {
            this.config = new PropertiesConfiguration(propertiesFile);
        }
        catch (ConfigurationException e) {
            System.out.println("*DEBUG* Did not find properties file '" + propertiesFile + "', using defaults");
        }
        if (this.config != null) {
            if (this.config.containsKey("connection.timeout")) {
                CONNECTION_TIMEOUT = this.config.getInt("connection.timeout");
                System.out.println("*TRACE* Set connection time to '" + CONNECTION_TIMEOUT + "'");
            }
            if (this.config.containsKey("use.uri.cache")) {
                this.useCache = this.config.getBoolean("use.uri.cache");
                System.out.println("*TRACE* Using URI cache");
            }
        }
    }

    @RobotKeyword
    public boolean jsonElementShouldMatch(String source, String jsonPath, Object value) throws Exception {
        boolean match = false;
        if (value == null) {
            throw new IllegalArgumentException("Given value was null");
        }
        String found = String.valueOf(this.findJsonElement(source, jsonPath));
        if (!found.equals(value)) {
            System.out.println("*ERROR* The values '" + found + "' and '" + value + "' did not match");
            throw new JsonNotEqualException("The found value did not match, found '" + found + "', expected '" + value + "'");
        }
        System.out.println("*DEBUG* The values '" + found + "' and '" + value + "' did match");
        match = true;
        return match;
    }

    @RobotKeyword
    public boolean jsonShouldBeEqual(String from, String to) throws Exception {
        return this.jsonShouldBeEqual(from, to, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RobotKeyword
    public boolean jsonShouldBeEqual(String from, String to, boolean useExactMatch) throws Exception {
        System.out.println("*DEBUG* Comparing JSON sources");
        boolean equal = false;
        String fromJson = this.readSource(from);
        String toJson = this.readSource(to);
        if (StringUtils.isNotBlank((CharSequence)fromJson) && StringUtils.isNotBlank((CharSequence)toJson)) {
            if (useExactMatch) {
                if (fromJson.equals(toJson)) {
                    System.out.println("*DEBUG* JSON strings are equal by exact compare");
                    return true;
                }
                System.out.println("*ERROR* JSON strings are NOT equal by exact compare");
                equal = false;
                throw new JsonNotEqualException("JSON strings are NOT equal by exact compare");
            }
            equal = this.diff.compare(fromJson, toJson);
            if (equal) return equal;
            throw new JsonNotEqualException("JSON strings are NOT equal by compare");
        }
        System.out.println("*ERROR* Either from or to JSON was empty");
        throw new JsonNotValidException("JSON strings are NOT equal by compare");
    }

    @RobotKeyword
    public Object findJsonElement(String source, String jsonPath) throws Exception {
        Object value;
        System.out.println("*DEBUG* Reading jsonPath: " + jsonPath);
        String json = this.readSource(source);
        try {
            value = JsonPath.read((String)json, (String)jsonPath, (Filter[])new Filter[0]);
        }
        catch (PathNotFoundException e) {
            throw new JsonElementNotFoundException("Path '" + jsonPath + "' was not found in JSON");
        }
        return value;
    }

    @RobotKeyword
    public List<Object> findJsonElementList(String source, String jsonPath) throws Exception {
        List elements;
        System.out.println("*DEBUG* Reading jsonPath: " + jsonPath);
        String json = this.readSource(source);
        try {
            elements = (List)JsonPath.read((String)json, (String)jsonPath, (Filter[])new Filter[0]);
        }
        catch (PathNotFoundException e) {
            throw new JsonElementNotFoundException("Path '" + jsonPath + "' was not found in JSON");
        }
        return elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RobotKeyword
    public boolean jsonShouldHaveElementCount(String source, String jsonPath, Integer count) throws Exception {
        boolean match = false;
        System.out.println("*DEBUG* Reading jsonPath: " + jsonPath);
        String json = this.readSource(source);
        List elements = null;
        Object object = null;
        try {
            object = JsonPath.read((String)json, (String)jsonPath, (Filter[])new Filter[0]);
        }
        catch (PathNotFoundException e) {
            throw new JsonElementNotFoundException("Path '" + jsonPath + "' was not found in JSON");
        }
        if (object != null) {
            if (object instanceof List) {
                elements = (List)object;
                if (CollectionUtils.isNotEmpty((Collection)elements)) {
                    if (elements.size() == count.intValue()) {
                        return true;
                    }
                    boolean bl = false;
                    match = bl;
                    if (match) return match;
                    System.out.println("*ERROR* Element counts did not match. Expected '" + count + "', got '" + elements.size() + "'");
                    throw new JsonNotEqualException("Element counts did not match. Expected '" + count + "', got '" + elements.size() + "'");
                }
                System.out.println("*ERROR* Could not find elements from '" + jsonPath + "'");
                throw new JsonElementNotFoundException("Could not find elements from '" + jsonPath + "'");
            }
            if (count == 1) {
                System.out.println("*DEBUG* Found 1 item as expected from '" + jsonPath + "'");
                return true;
            }
            System.out.println("*ERROR* Found 1 item, but expected '" + count + "'");
            throw new JsonElementNotFoundException("Found 1 item, but expected '" + count + "'");
        }
        System.out.println("*ERROR* Could not find elements from '" + jsonPath + "'");
        throw new JsonElementNotFoundException("Could not find elements from '" + jsonPath + "'");
    }

    protected String readSource(String source) {
        String json = null;
        if (StringUtils.isNotBlank((CharSequence)source)) {
            URI uri = this.getURI(source);
            if (uri != null) {
                json = this.loadURI(uri);
            } else {
                System.out.println("*DEBUG* The source is JSON");
                json = source;
            }
        } else {
            System.out.println("*ERROR* The source was empty or null: " + source);
        }
        return json;
    }

    protected String loadURI(URI uri) {
        String json = null;
        if (uri != null) {
            System.out.println("Use cache: " + this.useCache);
            if (this.useCache.booleanValue()) {
                json = this.uriCache.get(uri);
            }
            if (json == null) {
                System.out.println("*DEBUG* Did not find result from cache");
                try {
                    System.out.println("*TRACE* Loading the JSON from the URI");
                    if ("file".equals(uri.getScheme())) {
                        System.out.println("*DEBUG* Loading file system URI");
                        json = FileUtils.readFileToString((File)new File(uri));
                    } else {
                        System.out.println("*DEBUG* Loading external URI");
                        json = Request.Get((URI)uri).connectTimeout(CONNECTION_TIMEOUT).socketTimeout(CONNECTION_TIMEOUT).execute().returnContent().asString();
                    }
                    if (json != null && this.useCache.booleanValue()) {
                        System.out.println("*DEBUG* Storing value to the cache");
                        this.uriCache.put(uri, json);
                    }
                }
                catch (IOException e) {
                    System.out.println("*ERROR* Could not load json from URI " + uri + ", because " + e);
                }
            } else {
                System.out.println("*DEBUG* Found the result from cache");
            }
        } else {
            System.out.println("*DEBUG* The source is not an URI");
        }
        return json;
    }

    private URI getURI(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
            System.out.println("*DEBUG* The source " + url + " is an URL");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }
}

