/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class AuthenticationConfiguration {
    public final String userDn;
    public final String credentials;

    public AuthenticationConfiguration(String userDn, String credentials) {
        this.userDn = userDn;
        this.credentials = credentials;
    }

    public Map<String, String> toAuthenticationEnvironment() {
        if (this.userDn == null || this.credentials == null) {
            throw new IllegalStateException("userDn and credentials must be set before generating the authentication environment");
        }
        return ImmutableMap.builder().put((Object)"java.naming.security.principal", (Object)this.userDn).put((Object)"java.naming.security.protocol", (Object)"simple").put((Object)"java.naming.security.credentials", (Object)this.credentials).build();
    }
}

