/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap.internal;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.junit.ldap.EmbeddedLdapRule;
import org.zapodot.junit.ldap.internal.AuthenticationConfiguration;
import org.zapodot.junit.ldap.internal.jndi.ContextProxyFactory;
import org.zapodot.junit.ldap.internal.unboundid.LDAPInterfaceProxyFactory;

public class EmbeddedLdapRuleImpl
implements EmbeddedLdapRule {
    private static final String JAVA_RT_CONTROL_FACTORY = "com.sun.jndi.ldap.DefaultResponseControlFactory";
    private static final String JAVA_RT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static Logger logger = LoggerFactory.getLogger(EmbeddedLdapRuleImpl.class);
    private final InMemoryDirectoryServer inMemoryDirectoryServer;
    private final AuthenticationConfiguration authenticationConfiguration;
    private LDAPConnection ldapConnection;
    private InitialDirContext initialDirContext;
    private boolean isStarted = false;
    private final boolean useTls;
    private final SSLSocketFactory socketFactory;

    private EmbeddedLdapRuleImpl(InMemoryDirectoryServer inMemoryDirectoryServer, AuthenticationConfiguration authenticationConfiguration1, boolean useTls, SSLSocketFactory socketFactory) {
        this.inMemoryDirectoryServer = inMemoryDirectoryServer;
        this.authenticationConfiguration = authenticationConfiguration1;
        this.useTls = useTls;
        this.socketFactory = socketFactory;
    }

    public static EmbeddedLdapRule createForConfiguration(InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig, AuthenticationConfiguration authenticationConfiguration, List<String> ldifs, boolean useTls, SSLSocketFactory socketFactory) {
        try {
            return new EmbeddedLdapRuleImpl(EmbeddedLdapRuleImpl.createServer(inMemoryDirectoryServerConfig, ldifs), authenticationConfiguration, useTls, socketFactory);
        }
        catch (LDAPException e) {
            throw new IllegalStateException("Can not initiate in-memory LDAP server due to an exception", e);
        }
    }

    private static InMemoryDirectoryServer createServer(InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig, List<String> ldifs) throws LDAPException {
        InMemoryDirectoryServer ldapServer = new InMemoryDirectoryServer(inMemoryDirectoryServerConfig);
        if (ldifs != null && !ldifs.isEmpty()) {
            for (String ldif : ldifs) {
                try {
                    ldapServer.importFromLDIF(false, URLDecoder.decode(Resources.getResource((String)ldif).getPath(), Charsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Can not URL decode path:" + Resources.getResource((String)ldif).getPath(), e);
                }
            }
        }
        return ldapServer;
    }

    @Override
    public LDAPInterface ldapConnection() throws LDAPException {
        return LDAPInterfaceProxyFactory.createProxy(this.createOrGetLdapConnection());
    }

    @Override
    public LDAPConnection unsharedLdapConnection() throws LDAPException {
        return this.createOrGetLdapConnection();
    }

    private LDAPConnection createOrGetLdapConnection() throws LDAPException {
        if (this.isStarted) {
            if (this.ldapConnection == null || !this.ldapConnection.isConnected()) {
                this.ldapConnection = this.inMemoryDirectoryServer.getConnection();
            }
            return this.ldapConnection;
        }
        throw new IllegalStateException("Can not get a LdapConnection before the embedded LDAP server has been started");
    }

    @Override
    public Context context() throws NamingException {
        return ContextProxyFactory.asDelegatingContext(this.createOrGetInitialDirContext());
    }

    @Override
    public DirContext dirContext() throws NamingException {
        return ContextProxyFactory.asDelegatingDirContext(this.createOrGetInitialDirContext());
    }

    @Override
    public int embeddedServerPort() {
        if (this.isStarted) {
            return this.inMemoryDirectoryServer.getListenPort();
        }
        throw new IllegalStateException("The embedded server must be started prior to accessing the listening port");
    }

    private InitialDirContext createOrGetInitialDirContext() throws NamingException {
        if (this.isStarted) {
            if (this.initialDirContext == null) {
                this.initialDirContext = new InitialDirContext(this.createLdapEnvironment());
            }
            return this.initialDirContext;
        }
        throw new IllegalStateException("Can not get an InitialDirContext before the embedded LDAP server has been started");
    }

    private Hashtable<String, String> createLdapEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        if (this.socketFactory != null) {
            Class delegator = new ByteBuddy().subclass(AbstractDelegatingSocketFactory.class).defineMethod("getDelegate", SocketFactory.class, 4).intercept((Implementation)FixedValue.value((Object)this.socketFactory)).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            try {
                Object instance = delegator.newInstance();
                delegator.getField("INSTANCE").set(instance, instance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
            environment.put("java.naming.ldap.factory.socket", delegator.getCanonicalName());
        }
        environment.put("java.naming.factory.control", JAVA_RT_CONTROL_FACTORY);
        environment.put("java.naming.provider.url", String.format("%s://%s:%s", this.useTls ? "ldaps" : "ldap", this.inMemoryDirectoryServer.getListenAddress().getHostName(), this.embeddedServerPort()));
        environment.put("java.naming.factory.initial", JAVA_RT_CONTEXT_FACTORY);
        if (this.authenticationConfiguration != null) {
            environment.putAll(this.authenticationConfiguration.toAuthenticationEnvironment());
        }
        return environment;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                EmbeddedLdapRuleImpl.this.startEmbeddedLdapServer();
                try {
                    base.evaluate();
                }
                finally {
                    EmbeddedLdapRuleImpl.this.takeDownEmbeddedLdapServer();
                }
            }
        };
    }

    private void startEmbeddedLdapServer() throws LDAPException {
        this.inMemoryDirectoryServer.startListening();
        this.isStarted = true;
    }

    private void takeDownEmbeddedLdapServer() {
        try {
            if (this.ldapConnection != null && this.ldapConnection.isConnected()) {
                this.ldapConnection.close();
            }
            if (this.initialDirContext != null) {
                this.initialDirContext.close();
            }
        }
        catch (NamingException e) {
            logger.info("Could not close initial context, forcing server shutdown anyway", (Throwable)e);
        }
        finally {
            this.inMemoryDirectoryServer.shutDown(true);
        }
    }

    public static abstract class AbstractDelegatingSocketFactory
    extends SocketFactory {
        public static AbstractDelegatingSocketFactory INSTANCE;

        public static AbstractDelegatingSocketFactory getDefault() {
            return INSTANCE;
        }

        protected abstract SocketFactory getDelegate();

        @Override
        public Socket createSocket() throws IOException, UnknownHostException {
            return this.getDelegate().createSocket();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.getDelegate().createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.getDelegate().createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.getDelegate().createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.getDelegate().createSocket(address, port, localAddress, localPort);
        }
    }
}

