/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ClassHierarchyIntrospector;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ThreadLocalReference;

public class ThreadLocalComponentAdapter
extends DecoratingComponentAdapter {
    private static Map m_proxyMap = Collections.synchronizedMap(new HashMap());

    public ThreadLocalComponentAdapter(ComponentAdapter delegate) {
        super(new CachingComponentAdapter(delegate, new ThreadLocalReference()));
    }

    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentKey = this.getDelegate().getComponentKey();
        String key = String.valueOf(System.identityHashCode(componentKey)) + "." + String.valueOf(System.identityHashCode(this.getContainer()));
        Object proxy = m_proxyMap.get(key);
        if (proxy == null) {
            Class[] interfaces = componentKey instanceof Class && ((Class)componentKey).isInterface() ? new Class[]{(Class)this.getDelegate().getComponentKey()} : ClassHierarchyIntrospector.getAllInterfaces(this.getDelegate().getComponentImplementation()).toArray(new Class[0]);
            if (interfaces.length == 0) {
                throw new PicoIntrospectionException("Can't proxy implementation for " + this.getDelegate().getComponentImplementation().getName() + ". It doesn't implement any interfaces.");
            }
            ThreadLocalInvocationHandler threadLocalInvocationHandler = new ThreadLocalInvocationHandler();
            proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)threadLocalInvocationHandler);
            m_proxyMap.put(key, proxy);
        }
        return proxy;
    }

    private class ThreadLocalInvocationHandler
    implements InvocationHandler {
        private ThreadLocalInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object delegatedInstance = ThreadLocalComponentAdapter.this.getDelegate().getComponentInstance();
            return method.invoke(delegatedInstance, args);
        }
    }
}

