/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.aggregated;

import java.util.Arrays;
import java.util.HashSet;
import picocontainer.PicoContainer;
import picocontainer.PicoInitializationException;
import picocontainer.defaults.DefaultComponentFactory;
import picocontainer.defaults.DefaultPicoContainer;

public class AggregatedContainersContainer
extends DefaultPicoContainer {
    private final PicoContainer[] containers;

    public AggregatedContainersContainer(PicoContainer[] containers) {
        super(new DefaultComponentFactory());
        if (containers == null) {
            throw new NullPointerException("containers can't be null");
        }
        for (int i = 0; i < containers.length; ++i) {
            PicoContainer container = containers[i];
            if (container != null) continue;
            throw new NullPointerException("PicoContainer at position " + i + " was null");
        }
        this.containers = containers;
    }

    public boolean hasComponent(Class compType) {
        for (int i = 0; i < this.containers.length; ++i) {
            PicoContainer container = this.containers[i];
            if (!container.hasComponent(compType)) continue;
            return true;
        }
        return false;
    }

    public Object getComponent(Class compType) {
        for (int i = 0; i < this.containers.length; ++i) {
            PicoContainer container = this.containers[i];
            if (!container.hasComponent(compType)) continue;
            return container.getComponent(compType);
        }
        return null;
    }

    public Class[] getComponentTypes() {
        HashSet<Class> componentTypes = new HashSet<Class>();
        for (int i = 0; i < this.containers.length; ++i) {
            PicoContainer container = this.containers[i];
            componentTypes.addAll(Arrays.asList(container.getComponentTypes()));
        }
        return componentTypes.toArray(new Class[this.containers.length]);
    }

    public void instantiateComponents() throws PicoInitializationException {
    }

    public static class Filter
    extends AggregatedContainersContainer {
        private final PicoContainer subject;

        public Filter(PicoContainer container) {
            super(new PicoContainer[]{container});
            this.subject = container;
        }

        public PicoContainer getSubject() {
            return this.subject;
        }
    }
}

