/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picocontainer.ComponentFactory;
import picocontainer.PicoContainer;
import picocontainer.PicoInitializationException;
import picocontainer.PicoInvocationTargetInitailizationException;
import picocontainer.PicoRegistrationException;
import picocontainer.defaults.ComponentSpecification;
import picocontainer.defaults.DefaultComponentFactory;
import picocontainer.hierarchical.AmbiguousComponentResolutionException;
import picocontainer.hierarchical.AssignabilityRegistrationException;
import picocontainer.hierarchical.DuplicateComponentTypeRegistrationException;
import picocontainer.hierarchical.NotConcreteRegistrationException;
import picocontainer.hierarchical.UnsatisfiedDependencyStartupException;
import picocontainer.hierarchical.WrongNumberOfConstructorsRegistrationException;

public class DefaultPicoContainer
implements PicoContainer {
    private final ComponentFactory componentFactory;
    private List registeredComponents = new ArrayList();
    private Map componentTypeToInstanceMap = new HashMap();
    protected List orderedComponents = new ArrayList();
    protected List unmanagedComponents = new ArrayList();
    private Map parametersForComponent = new HashMap();
    private boolean initialized;

    public DefaultPicoContainer(ComponentFactory componentFactory) {
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory cannot be null");
        }
        this.componentFactory = componentFactory;
    }

    public final Object[] getComponents() {
        Class[] componentTypes = this.getComponentTypes();
        Object[] components = new Object[componentTypes.length];
        for (int i = 0; i < componentTypes.length; ++i) {
            Class componentType = componentTypes[i];
            components[i] = this.getComponent(componentType);
        }
        return components;
    }

    public Object getMultipleInheritanceProxy() {
        return this.getAggregateComponentProxy(true, true);
    }

    public Object getAggregateComponentProxy(boolean callInInstantiationOrder, boolean callUnmanagedComponents) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getComponentInterfaces(), (InvocationHandler)new ComponentsInvocationHandler(callInInstantiationOrder, callUnmanagedComponents));
    }

    private final Class[] getComponentInterfaces() {
        HashSet interfaces = new HashSet();
        Object[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            for (Class<?> componentClass = components[i].getClass(); componentClass != null; componentClass = componentClass.getSuperclass()) {
                Class<?>[] implemeted = componentClass.getInterfaces();
                List<Class<?>> implementedList = Arrays.asList(implemeted);
                interfaces.addAll(implementedList);
            }
        }
        Class[] result = interfaces.toArray(new Class[interfaces.size()]);
        return result;
    }

    public void registerComponent(Class componentType, Class componentImplementation) throws DuplicateComponentTypeRegistrationException, AssignabilityRegistrationException, NotConcreteRegistrationException, WrongNumberOfConstructorsRegistrationException {
        this.checkConcrete(componentImplementation);
        this.checkConstructor(componentImplementation);
        this.checkTypeCompatibility(componentType, componentImplementation);
        this.checkTypeDuplication(componentType);
        this.registeredComponents.add(new ComponentSpecification(componentType, componentImplementation));
    }

    private void checkConstructor(Class componentImplementation) throws WrongNumberOfConstructorsRegistrationException {
        Constructor<?>[] constructors = componentImplementation.getConstructors();
        if (constructors.length != 1) {
            throw new WrongNumberOfConstructorsRegistrationException(constructors.length);
        }
    }

    private void checkTypeDuplication(Class componentType) throws DuplicateComponentTypeRegistrationException {
        Iterator iterator = this.registeredComponents.iterator();
        while (iterator.hasNext()) {
            Class aClass = ((ComponentSpecification)iterator.next()).getComponentType();
            if (aClass != componentType) continue;
            throw new DuplicateComponentTypeRegistrationException(aClass);
        }
    }

    private void checkTypeCompatibility(Class componentType, Class componentImplementation) throws AssignabilityRegistrationException {
        if (!componentType.isAssignableFrom(componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, componentImplementation);
        }
    }

    private void checkConcrete(Class componentImplementation) throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (componentImplementation.getModifiers() & 0x400) == 1024;
        if (componentImplementation.isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(componentImplementation);
        }
    }

    public void registerComponent(Object component) throws PicoRegistrationException {
        this.registerComponent(component.getClass(), component);
    }

    public void registerComponent(Class componentType, Object component) throws PicoRegistrationException {
        this.checkTypeCompatibility(componentType, component.getClass());
        this.checkTypeDuplication(componentType);
        this.componentTypeToInstanceMap.put(componentType, component);
        this.orderedComponents.add(component);
        this.unmanagedComponents.add(component);
    }

    public void addParameterToComponent(Class componentType, Class parameter, Object arg) {
        if (!this.parametersForComponent.containsKey(componentType)) {
            this.parametersForComponent.put(componentType, new ArrayList());
        }
        List args = (List)this.parametersForComponent.get(componentType);
        args.add(new ParameterSpec(arg));
    }

    public void registerComponent(Class componentImplementation) throws DuplicateComponentTypeRegistrationException, AssignabilityRegistrationException, NotConcreteRegistrationException, WrongNumberOfConstructorsRegistrationException {
        this.registerComponent(componentImplementation, componentImplementation);
    }

    public void instantiateComponents() throws PicoInitializationException {
        if (this.initialized) {
            throw new IllegalStateException("PicoContainer Started Already");
        }
        this.initializeComponents();
        this.checkUnsatisfiedDependencies();
        this.initialized = true;
    }

    private void initializeComponents() throws AmbiguousComponentResolutionException, PicoInvocationTargetInitailizationException {
        boolean progress = true;
        while (progress) {
            progress = false;
            Iterator iterator = this.registeredComponents.iterator();
            while (iterator.hasNext()) {
                ComponentSpecification componentSpec = (ComponentSpecification)iterator.next();
                Class componentImplementation = componentSpec.getComponentImplementation();
                Class componentType = componentSpec.getComponentType();
                if (this.componentTypeToInstanceMap.get(componentType) != null) continue;
                boolean reused = this.reuseImplementationIfAppropriate(componentType, componentImplementation);
                if (reused) {
                    progress = true;
                    continue;
                }
                progress = this.hookEmUp(componentImplementation, componentType, progress);
            }
        }
    }

    protected boolean hookEmUp(Class componentImplementation, Class componentType, boolean progress) throws AmbiguousComponentResolutionException, PicoInvocationTargetInitailizationException {
        Constructor<?>[] constructors = componentImplementation.getConstructors();
        Constructor<?> constructor = constructors[0];
        Class<?>[] parameters = constructor.getParameterTypes();
        List paramSpecs = (List)this.parametersForComponent.get(componentImplementation);
        paramSpecs = paramSpecs == null ? Collections.EMPTY_LIST : new LinkedList(paramSpecs);
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> param = parameters[i];
            args[i] = this.getComponentForParam(param);
            if (args[i] != null || paramSpecs.isEmpty()) continue;
            args[i] = ((ParameterSpec)paramSpecs.remove(0)).arg;
        }
        if (!this.hasAnyNullArguments(args)) {
            Object componentInstance = null;
            componentInstance = this.makeComponentInstance(componentType, constructor, args);
            this.componentTypeToInstanceMap.put(componentType, componentInstance);
            this.orderedComponents.add(componentInstance);
            progress = true;
        }
        return progress;
    }

    protected boolean reuseImplementationIfAppropriate(Class componentType, Class componentImplementation) {
        Set compEntries = this.componentTypeToInstanceMap.entrySet();
        Iterator iterator = compEntries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object exisitingCompClass = entry.getValue();
            if (exisitingCompClass.getClass() != componentImplementation) continue;
            this.componentTypeToInstanceMap.put(componentType, exisitingCompClass);
            return true;
        }
        return false;
    }

    private void checkUnsatisfiedDependencies() throws UnsatisfiedDependencyStartupException {
        Iterator iterator = this.registeredComponents.iterator();
        while (iterator.hasNext()) {
            ComponentSpecification componentSpecification = (ComponentSpecification)iterator.next();
            Class componentType = componentSpecification.getComponentType();
            if (this.componentTypeToInstanceMap.get(componentType) != null) continue;
            throw new UnsatisfiedDependencyStartupException(componentType);
        }
    }

    protected Object makeComponentInstance(Class type, Constructor constructor, Object[] args) throws PicoInvocationTargetInitailizationException {
        return this.componentFactory.createComponent(type, constructor, args);
    }

    protected Object getComponentForParam(Class parameter) throws AmbiguousComponentResolutionException {
        Object result = null;
        ArrayList<Class> candidateClasses = new ArrayList<Class>();
        Iterator iterator = this.componentTypeToInstanceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class clazz = (Class)entry.getKey();
            if (!parameter.isAssignableFrom(clazz)) continue;
            candidateClasses.add(clazz);
            result = entry.getValue();
        }
        if (candidateClasses.size() > 1) {
            Class[] ambiguities = candidateClasses.toArray(new Class[candidateClasses.size()]);
            throw new AmbiguousComponentResolutionException(ambiguities);
        }
        return result;
    }

    private boolean hasAnyNullArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg != null) continue;
            return true;
        }
        return false;
    }

    public Object getComponent(Class componentType) {
        return this.componentTypeToInstanceMap.get(componentType);
    }

    public Class[] getComponentTypes() {
        Set types = this.componentTypeToInstanceMap.keySet();
        return types.toArray(new Class[types.size()]);
    }

    public boolean hasComponent(Class componentType) {
        return this.getComponent(componentType) != null;
    }

    private class ParameterSpec {
        private Object arg;

        ParameterSpec(Object parameter) {
            this.arg = parameter;
        }
    }

    private class ComponentsInvocationHandler
    implements InvocationHandler {
        private boolean callInInstantiationOrder;
        private boolean callUnmanagedComponents;

        public ComponentsInvocationHandler(boolean callInInstantiationOrder, boolean callUnmanagedComponents) {
            this.callInInstantiationOrder = callInInstantiationOrder;
            this.callUnmanagedComponents = callUnmanagedComponents;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ArrayList orderedComponentsCopy = new ArrayList(DefaultPicoContainer.this.orderedComponents);
            if (!this.callInInstantiationOrder) {
                Collections.reverse(orderedComponentsCopy);
            }
            Object[] components = orderedComponentsCopy.toArray();
            return this.invokeOnComponents(components, method, args);
        }

        private Object invokeOnComponents(Object[] components, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            Object result = null;
            int invokeCount = 0;
            for (int i = 0; i < components.length; ++i) {
                boolean exclude;
                Class<?> declarer = method.getDeclaringClass();
                boolean isValidType = declarer.isAssignableFrom(components[i].getClass());
                boolean isUnmanaged = DefaultPicoContainer.this.unmanagedComponents.contains(components[i]);
                boolean bl = exclude = !this.callUnmanagedComponents && isUnmanaged;
                if (!isValidType || exclude) continue;
                Object resultCandidate = method.invoke(components[i], args);
                result = ++invokeCount == 1 ? resultCandidate : null;
            }
            return result;
        }
    }

    public static class Default
    extends DefaultPicoContainer {
        public Default() {
            super(new DefaultComponentFactory());
        }
    }
}

