/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import picocontainer.ComponentFactory;
import picocontainer.PicoIntrospectionException;
import picocontainer.defaults.PicoInvocationTargetInitializationException;
import picocontainer.defaults.WrongNumberOfConstructorsException;

public class DefaultComponentFactory
implements ComponentFactory {
    public Object createComponent(Class componentType, Class componentImplementation, Class[] dependencies, Object[] instanceDependencies) throws PicoInvocationTargetInitializationException, WrongNumberOfConstructorsException {
        try {
            Constructor constructor = this.getConstructor(componentImplementation);
            return constructor.newInstance(instanceDependencies);
        }
        catch (InvocationTargetException e) {
            throw new PicoInvocationTargetInitializationException(e.getCause());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Class[] getDependencies(Class componentImplementation) throws PicoIntrospectionException {
        Constructor constructor = this.getConstructor(componentImplementation);
        return constructor.getParameterTypes();
    }

    private Constructor getConstructor(Class componentImplementation) throws WrongNumberOfConstructorsException {
        Constructor<?>[] constructors = componentImplementation.getConstructors();
        if (constructors.length != 1) {
            throw new WrongNumberOfConstructorsException(constructors.length);
        }
        return componentImplementation.getConstructors()[0];
    }
}

