/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.defaults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picocontainer.ClassRegistrationPicoContainer;
import picocontainer.ComponentFactory;
import picocontainer.PicoInstantiationException;
import picocontainer.PicoIntrospectionException;
import picocontainer.PicoRegistrationException;
import picocontainer.defaults.AggregateProxyFactory;
import picocontainer.defaults.AmbiguousComponentResolutionException;
import picocontainer.defaults.AssignabilityRegistrationException;
import picocontainer.defaults.ComponentParameter;
import picocontainer.defaults.ComponentSpecification;
import picocontainer.defaults.DefaultAggregateProxyFactory;
import picocontainer.defaults.DefaultComponentFactory;
import picocontainer.defaults.DuplicateComponentTypeRegistrationException;
import picocontainer.defaults.NotConcreteRegistrationException;
import picocontainer.defaults.Parameter;
import picocontainer.defaults.PicoInvocationTargetInitializationException;

public class DefaultPicoContainer
implements ClassRegistrationPicoContainer {
    private final ComponentFactory componentFactory;
    private List registeredComponents = new ArrayList();
    private Map componentTypeToInstanceMap = new HashMap();
    protected List orderedComponents = new ArrayList();
    protected List unmanagedComponents = new ArrayList();
    private boolean initialized;
    private Map componentToSpec = new HashMap();
    private AggregateProxyFactory aggregateProxyFactory = new DefaultAggregateProxyFactory();

    public DefaultPicoContainer(ComponentFactory componentFactory) {
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory cannot be null");
        }
        this.componentFactory = componentFactory;
    }

    public final Object[] getComponents() {
        Class[] componentTypes = this.getComponentTypes();
        Object[] components = new Object[componentTypes.length];
        for (int i = 0; i < componentTypes.length; ++i) {
            Class componentType = componentTypes[i];
            components[i] = this.getComponent(componentType);
        }
        return components;
    }

    public Object getAggregateComponentProxy() {
        return this.getAggregateComponentProxy(true, false);
    }

    public Object getAggregateComponentProxy(boolean callInInstantiationOrder, boolean callUnmanagedComponents) {
        ArrayList aggregateComponents = new ArrayList(this.orderedComponents);
        if (!callUnmanagedComponents) {
            Iterator iterator = this.unmanagedComponents.iterator();
            while (iterator.hasNext()) {
                aggregateComponents.remove(iterator.next());
            }
        }
        return this.aggregateProxyFactory.createAggregateProxy(this.getClass().getClassLoader(), aggregateComponents, callInInstantiationOrder);
    }

    public void registerComponent(Class componentType, Class componentImplementation) throws DuplicateComponentTypeRegistrationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        this.checkConcrete(componentImplementation);
        Parameter[] parameters = new Parameter[this.componentFactory.getDependencies(componentImplementation).length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.createDefaultParameter();
        }
        this.registerComponent(componentType, componentImplementation, parameters);
    }

    public void registerComponent(Class componentType, Class componentImplementation, Parameter[] parameters) throws NotConcreteRegistrationException, AssignabilityRegistrationException, DuplicateComponentTypeRegistrationException {
        this.checkConcrete(componentImplementation);
        this.checkTypeCompatibility(componentType, componentImplementation);
        this.checkTypeDuplication(componentType);
        ComponentSpecification compSpec = new ComponentSpecification(this.componentFactory, componentType, componentImplementation, parameters);
        this.componentToSpec.put(componentImplementation, compSpec);
        this.registeredComponents.add(compSpec);
    }

    protected Parameter createDefaultParameter() {
        return new ComponentParameter();
    }

    private void checkTypeDuplication(Class componentType) throws DuplicateComponentTypeRegistrationException {
        Iterator iterator = this.registeredComponents.iterator();
        while (iterator.hasNext()) {
            Class aClass = ((ComponentSpecification)iterator.next()).getComponentType();
            if (aClass != componentType) continue;
            throw new DuplicateComponentTypeRegistrationException(aClass);
        }
    }

    private void checkTypeCompatibility(Class componentType, Class componentImplementation) throws AssignabilityRegistrationException {
        if (!componentType.isAssignableFrom(componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, componentImplementation);
        }
    }

    private void checkConcrete(Class componentImplementation) throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (componentImplementation.getModifiers() & 0x400) == 1024;
        if (componentImplementation.isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(componentImplementation);
        }
    }

    public void registerComponent(Object component) throws PicoRegistrationException {
        this.registerComponent(component.getClass(), component);
    }

    public void registerComponent(Class componentType, Object component) throws PicoRegistrationException {
        this.checkTypeCompatibility(componentType, component.getClass());
        this.checkTypeDuplication(componentType);
        this.componentTypeToInstanceMap.put(componentType, component);
        this.orderedComponents.add(component);
        this.unmanagedComponents.add(component);
    }

    public void addParameterToComponent(Class componentType, Class parameter, Object arg) throws PicoIntrospectionException {
        ComponentSpecification componentSpec = (ComponentSpecification)this.componentToSpec.get(componentType);
        componentSpec.addConstantParameterBasedOnType(componentType, parameter, arg);
    }

    public void registerComponent(Class componentImplementation) throws DuplicateComponentTypeRegistrationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        this.registerComponent(componentImplementation, componentImplementation);
    }

    public void instantiateComponents() throws PicoInstantiationException, PicoInvocationTargetInitializationException, PicoIntrospectionException {
        if (this.initialized) {
            throw new IllegalStateException("PicoContainer Started Already");
        }
        this.initializeComponents();
        this.initialized = true;
    }

    private void initializeComponents() throws PicoInstantiationException, PicoIntrospectionException {
        Iterator iterator = this.registeredComponents.iterator();
        while (iterator.hasNext()) {
            ComponentSpecification componentSpec = (ComponentSpecification)iterator.next();
            this.createComponent(componentSpec);
        }
    }

    private Object createComponent(ComponentSpecification componentSpecification) throws PicoInstantiationException, PicoIntrospectionException {
        if (!this.componentTypeToInstanceMap.containsKey(componentSpecification.getComponentType())) {
            Object component = null;
            Set compEntries = this.componentTypeToInstanceMap.entrySet();
            Iterator iterator = compEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object exisitingComp = entry.getValue();
                if (exisitingComp.getClass() != componentSpecification.getComponentImplementation()) continue;
                component = exisitingComp;
                break;
            }
            if (component == null) {
                component = componentSpecification.instantiateComponent(this);
                this.orderedComponents.add(component);
            }
            this.componentTypeToInstanceMap.put(componentSpecification.getComponentType(), component);
            return component;
        }
        return this.componentTypeToInstanceMap.get(componentSpecification.getComponentType());
    }

    public Object getComponent(Class componentType) {
        return this.componentTypeToInstanceMap.get(componentType);
    }

    Object createComponent(Class componentType) throws PicoInstantiationException, PicoIntrospectionException {
        Object componentInstance = this.getComponent(componentType);
        if (componentInstance != null) {
            return componentInstance;
        }
        componentInstance = this.findSatisfyingComponent(componentType);
        if (componentInstance != null) {
            return componentInstance;
        }
        ComponentSpecification componentSpecification = this.findComponentSpecification(componentType);
        if (componentSpecification == null) {
            return null;
        }
        componentType = componentSpecification.getComponentType();
        componentInstance = this.createComponent(componentSpecification);
        return componentInstance;
    }

    private Object findSatisfyingComponent(Class componentType) throws AmbiguousComponentResolutionException {
        ArrayList<Class> found = new ArrayList<Class>();
        Iterator iterator = this.componentTypeToInstanceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class candidateType = (Class)entry.getKey();
            if (!componentType.isAssignableFrom(candidateType)) continue;
            found.add(candidateType);
        }
        if (found.size() > 1) {
            Class[] ambiguousClasses = found.toArray(new Class[found.size()]);
            throw new AmbiguousComponentResolutionException(ambiguousClasses);
        }
        return found.isEmpty() ? null : this.componentTypeToInstanceMap.get(found.get(0));
    }

    ComponentSpecification findComponentSpecification(Class componentType) throws AmbiguousComponentResolutionException {
        ArrayList<ComponentSpecification> found = new ArrayList<ComponentSpecification>();
        Iterator iterator = this.registeredComponents.iterator();
        while (iterator.hasNext()) {
            ComponentSpecification componentSpecification = (ComponentSpecification)iterator.next();
            if (!componentType.isAssignableFrom(componentSpecification.getComponentType())) continue;
            found.add(componentSpecification);
        }
        if (found.size() > 1) {
            Class[] ambiguousClass = new Class[found.size()];
            for (int i = 0; i < ambiguousClass.length; ++i) {
                ambiguousClass[i] = ((ComponentSpecification)found.get(i)).getComponentImplementation();
            }
            throw new AmbiguousComponentResolutionException(ambiguousClass);
        }
        return found.isEmpty() ? null : (ComponentSpecification)found.get(0);
    }

    public Class[] getComponentTypes() {
        Set types = this.componentTypeToInstanceMap.keySet();
        return types.toArray(new Class[types.size()]);
    }

    public final boolean hasComponent(Class componentType) {
        return this.getComponent(componentType) != null;
    }

    public static class Default
    extends DefaultPicoContainer {
        public Default() {
            super(new DefaultComponentFactory());
        }
    }
}

