/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.extras;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import picocontainer.ComponentFactory;
import picocontainer.PicoInstantiationException;
import picocontainer.PicoIntrospectionException;

public class BeanStyleComponentFactory
implements ComponentFactory {
    public Object createComponent(Class componentType, Class componentImplementation, Class[] dependencies, Object[] instanceDependencies) throws PicoInstantiationException, PicoIntrospectionException {
        Object result = null;
        try {
            result = componentImplementation.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("#3 Can we have a concerted effort to try to force these excptions?");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("#4 Can we have a concerted effort to try to force these excptions?");
        }
        Method[] setters = this.getSetters(componentImplementation);
        if (setters.length != instanceDependencies.length) {
            throw new IllegalStateException("Unmatching number of dependencies: " + setters.length + " vs " + instanceDependencies.length);
        }
        for (int i = 0; i < setters.length; ++i) {
            Method setter = setters[i];
            Object argument = instanceDependencies[i];
            try {
                setter.invoke(result, argument);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("#5 Can we have a concerted effort to try to force these excptions?");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("#6 Can we have a concerted effort to try to force these excptions?");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("#7 Can we have a concerted effort to try to force these excptions?");
            }
        }
        return result;
    }

    public Class[] getDependencies(Class componentImplementation) throws PicoIntrospectionException {
        Method[] setters = this.getSetters(componentImplementation);
        Class[] result = new Class[setters.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = setters[i].getParameterTypes()[0];
        }
        return result;
    }

    private Method[] getSetters(Class componentImplementation) {
        ArrayList<Method> setters = new ArrayList<Method>();
        Method[] methods = componentImplementation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean isBeanStyle;
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean hasOneParameter = parameterTypes.length == 1;
            boolean bl = isBeanStyle = method.getName().length() >= 4 && method.getName().startsWith("set") && Character.isUpperCase(method.getName().charAt(3));
            if (!hasOneParameter || !isBeanStyle) continue;
            setters.add(method);
        }
        return setters.toArray(new Method[setters.size()]);
    }
}

