/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.extras;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import picocontainer.ComponentFactory;
import picocontainer.PicoInstantiationException;
import picocontainer.PicoIntrospectionException;

public class ImplementationHidingComponentFactory
implements ComponentFactory {
    private final ComponentFactory componentFactory;

    public ImplementationHidingComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public Object createComponent(Class componentType, Class componentImplementation, Class[] dependencies, Object[] instanceDependencies) throws PicoInstantiationException, PicoIntrospectionException {
        Object componentInstance = this.componentFactory.createComponent(componentType, componentImplementation, dependencies, instanceDependencies);
        return Proxy.newProxyInstance(componentImplementation.getClass().getClassLoader(), new Class[]{componentType}, (InvocationHandler)new ImplementationHidingProxy(componentInstance));
    }

    public Class[] getDependencies(Class componentImplementation) throws PicoIntrospectionException {
        return this.componentFactory.getDependencies(componentImplementation);
    }

    private class ImplementationHidingProxy
    implements InvocationHandler {
        private Object componentInstance;

        public ImplementationHidingProxy(Object componentInstance) {
            if (componentInstance == null) {
                throw new NullPointerException("componentInstance can't be null");
            }
            this.componentInstance = componentInstance;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.componentInstance, args);
        }
    }
}

