/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.hierarchical;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import picocontainer.ClassRegistrationPicoContainer;
import picocontainer.ComponentFactory;
import picocontainer.PicoContainer;
import picocontainer.defaults.DefaultComponentFactory;
import picocontainer.defaults.DefaultPicoContainer;
import picocontainer.defaults.NullContainer;

public class HierarchicalPicoContainer
extends DefaultPicoContainer
implements ClassRegistrationPicoContainer {
    private final PicoContainer parentContainer;

    public HierarchicalPicoContainer(ComponentFactory componentFactory, PicoContainer parentContainer) {
        super(componentFactory);
        if (parentContainer == null) {
            throw new NullPointerException("parentContainer cannot be null");
        }
        this.parentContainer = parentContainer;
    }

    public Object getComponent(Class componentType) {
        Object result = super.getComponent(componentType);
        if (result == null) {
            result = this.parentContainer.getComponent(componentType);
        }
        return result;
    }

    public Class[] getComponentTypes() {
        List<Class> myTypes = Arrays.asList(super.getComponentTypes());
        HashSet<Class> types = new HashSet<Class>(myTypes);
        types.addAll(Arrays.asList(this.parentContainer.getComponentTypes()));
        return types.toArray(new Class[types.size()]);
    }

    public static class WithComponentFactory
    extends HierarchicalPicoContainer {
        public WithComponentFactory(ComponentFactory componentFactory) {
            super(componentFactory, new NullContainer());
        }
    }

    public static class WithParentContainer
    extends HierarchicalPicoContainer {
        public WithParentContainer(PicoContainer parentContainer) {
            super(new DefaultComponentFactory(), parentContainer);
        }
    }

    public static class Default
    extends HierarchicalPicoContainer {
        public Default() {
            super(new DefaultComponentFactory(), new NullContainer());
        }
    }
}

